/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class BooleanArrayFSImpl
extends CommonAuxArrayFSImpl
implements BooleanArrayFS {
    public BooleanArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new BooleanArrayGenerator();
    }

    public boolean get(int i) {
        this.casImpl.checkArrayBounds(this.addr, i);
        return this.casImpl.ll_getBooleanArrayValue(this.addr, i);
    }

    public void set(int i, boolean val) throws ArrayIndexOutOfBoundsException {
        this.casImpl.checkArrayBounds(this.addr, i);
        this.casImpl.ll_setBooleanArrayValue(this.addr, i, val);
    }

    public void copyFromArray(boolean[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.casImpl.ll_setBooleanArrayValue(this.addr, destOffset + i, src[srcOffset + i]);
        }
    }

    public void copyToArray(int srcOffset, boolean[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.casImpl.ll_getBooleanArrayValue(this.addr, i + srcOffset);
        }
    }

    public boolean[] toArray() {
        int size2 = this.size();
        boolean[] outArray = new boolean[size2];
        this.copyToArray(0, outArray, 0, size2);
        return outArray;
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Boolean.toString(this.casImpl.ll_getBooleanArrayValue(this.addr, i + srcOffset));
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            String item = src[srcOffset + i];
            this.casImpl.ll_setBooleanArrayValue(this.addr, destOffset + i, null != item && item.equalsIgnoreCase("true"));
        }
    }

    private static class BooleanArrayGenerator
    implements FSGenerator {
        private BooleanArrayGenerator() {
        }

        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new BooleanArrayFSImpl(addr, cas);
        }
    }
}

