/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.AnalysisProcessData;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.JCasIterator;
import org.apache.uima.analysis_engine.ResultNotSupportedException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.analysis_engine.impl.JCasIteratorWrapper;
import org.apache.uima.analysis_engine.impl.ResultSpecification_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.Language;
import org.apache.uima.internal.util.JmxMBeanAgent;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.ConfigurableResource_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTraceEvent_impl;
import org.apache.uima.util.impl.ProcessTrace_impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysisEngineImplBase
extends ConfigurableResource_ImplBase
implements TextAnalysisEngine {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    public static final String PARAM_VERIFICATION_MODE = "VERIFICATION_MODE";
    private Properties mPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();
    private UimaTimer mProcessTimer = UIMAFramework.newTimer();
    private boolean mProcessTraceEnabled = true;
    private Object mMBeanServer;
    private String mMBeanNamePrefix;

    @Override
    protected void setMetaData(ResourceMetaData aMetaData) {
        super.setMetaData(aMetaData);
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
    }

    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        return null;
    }

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        boolean result2 = super.initialize(aSpecifier, aAdditionalParams);
        if (result2) {
            AnalysisEngineMetaData md = this.getAnalysisEngineMetaData();
            this.getCasManager().addMetaData((AnalysisEngineMetaData)md.clone());
            Properties perfSettings = null;
            this.mMBeanServer = null;
            this.mMBeanNamePrefix = null;
            if (aAdditionalParams != null) {
                perfSettings = (Properties)aAdditionalParams.get("PERFORMANCE_TUNING_SETTINGS");
                this.mMBeanServer = aAdditionalParams.get("MBEAN_SERVER");
                this.mMBeanNamePrefix = (String)aAdditionalParams.get("MBEAN_NAME_PREFIX");
            }
            if (perfSettings != null) {
                this.setPerformanceTuningSettings(perfSettings);
            }
            this.getMBean().setName(this.getMetaData().getName(), this.getUimaContextAdmin(), this.mMBeanNamePrefix);
            JmxMBeanAgent.registerMBean(this.getManagementInterface(), this.mMBeanServer);
            this.getCasManager().setJmxInfo(this.mMBeanServer, this.getUimaContextAdmin().getRootContext().getManagementInterface().getUniqueMBeanName());
        }
        return result2;
    }

    protected void finalize() throws Throwable {
        AnalysisEngineManagement mbean = this.getManagementInterface();
        if (mbean != null) {
            JmxMBeanAgent.unregisterMBean(mbean, this.mMBeanServer);
        }
        super.finalize();
    }

    @Override
    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return (AnalysisEngineMetaData)this.getMetaData();
    }

    @Override
    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        return (ProcessingResourceMetaData)this.getMetaData();
    }

    @Override
    public synchronized CAS newCAS() throws ResourceInitializationException {
        CasDefinition casDef = this.getCasManager().getCasDefinition();
        return CasCreationUtils.createCas(casDef, this.getPerformanceTuningSettings());
    }

    @Override
    public JCas newJCas() throws ResourceInitializationException {
        try {
            return this.newCAS().getJCas();
        }
        catch (CASException e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public ProcessTrace process(CAS aCAS, ResultSpecification aResultSpec) throws ResultNotSupportedException, AnalysisEngineProcessException {
        this.setResultSpecification(aResultSpec);
        return this.process(aCAS);
    }

    @Override
    public void process(CAS aCAS, ResultSpecification aResultSpec, ProcessTrace aTrace) throws ResultNotSupportedException, AnalysisEngineProcessException {
        this.setResultSpecification(aResultSpec);
        this.process(aCAS);
        this.buildProcessTraceFromMBeanStats(aTrace);
    }

    @Override
    public ProcessTrace process(CAS aCAS) throws AnalysisEngineProcessException {
        CasIterator iter2 = this.processAndOutputNewCASes(aCAS);
        while (iter2.hasNext()) {
            CAS cas = iter2.next();
            cas.release();
        }
        return this.buildProcessTraceFromMBeanStats();
    }

    @Override
    public ProcessTrace process(JCas aJCas) throws AnalysisEngineProcessException {
        return this.process(aJCas.getCas());
    }

    @Override
    public ProcessTrace process(JCas aJCas, ResultSpecification aResultSpec) throws ResultNotSupportedException, AnalysisEngineProcessException {
        return this.process(aJCas.getCas(), aResultSpec);
    }

    @Override
    public void process(JCas aJCas, ResultSpecification aResultSpec, ProcessTrace aTrace) throws ResultNotSupportedException, AnalysisEngineProcessException {
        this.process(aJCas.getCas(), aResultSpec, aTrace);
    }

    @Override
    @Deprecated
    public void process(AnalysisProcessData aProcessData, ResultSpecification aResultSpec) throws ResultNotSupportedException, AnalysisEngineProcessException {
        this.process(aProcessData.getCAS(), aResultSpec, aProcessData.getProcessTrace());
    }

    @Override
    public void processCas(CAS aCAS) throws ResourceProcessException {
        try {
            this.process(aCAS);
        }
        catch (AnalysisEngineProcessException e) {
            throw new ResourceProcessException(e);
        }
    }

    @Override
    public void processCas(CAS[] aCASes) throws ResourceProcessException {
        for (int i = 0; i < aCASes.length; ++i) {
            if (aCASes[i] == null) continue;
            this.processCas(aCASes[i]);
        }
    }

    @Override
    public JCasIterator processAndOutputNewCASes(JCas aJCas) throws AnalysisEngineProcessException {
        return new JCasIteratorWrapper(this.processAndOutputNewCASes(aJCas.getCas()));
    }

    @Override
    public ResultSpecification createResultSpecification() {
        return new ResultSpecification_impl();
    }

    @Override
    public ResultSpecification createResultSpecification(TypeSystem aTypeSystem) {
        return new ResultSpecification_impl(aTypeSystem);
    }

    @Override
    public synchronized String[] getFeatureNamesForType(String aTypeName) {
        CAS cas = this.getCasManager().getCas(this.getUimaContextAdmin().getQualifiedContextName());
        TypeSystem ts = cas.getTypeSystem();
        this.getCasManager().releaseCas(cas);
        Type t = ts.getType(aTypeName);
        if (t != null) {
            List<Feature> features = t.getFeatures();
            String[] featNames = new String[features.size()];
            for (int i = 0; i < features.size(); ++i) {
                Feature f2 = features.get(i);
                featNames[i] = f2.getShortName();
            }
            return featNames;
        }
        return null;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        OperationalProperties opProps = this.getAnalysisEngineMetaData().getOperationalProperties();
        return opProps == null ? false : !opProps.getModifiesCas();
    }

    @Override
    public void typeSystemInit(TypeSystem aTypeSystem) throws ResourceInitializationException {
    }

    @Override
    public Properties getPerformanceTuningSettings() {
        return this.mPerformanceTuningSettings;
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
    }

    public void resetResultSpecificationToDefault() {
        ResultSpecification_impl resultSpec = new ResultSpecification_impl();
        resultSpec.addCapabilities(this.getAnalysisEngineMetaData().getCapabilities());
        this.setResultSpecification(resultSpec);
    }

    @Override
    public AnalysisEngineManagement getManagementInterface() {
        UimaContextAdmin uc = this.getUimaContextAdmin();
        return uc == null ? null : uc.getManagementInterface();
    }

    @Override
    public void batchProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        this.batchProcessComplete();
    }

    @Override
    public void collectionProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        this.collectionProcessComplete();
    }

    protected void setPerformanceTuningSettings(Properties aSettings) {
        this.mPerformanceTuningSettings = (Properties)aSettings.clone();
        String procTrEnabled = this.mPerformanceTuningSettings.getProperty("process_trace_enabled");
        this.mProcessTraceEnabled = procTrEnabled == null || procTrEnabled.equalsIgnoreCase("true");
    }

    protected void normalizeIsoLangCodes(ProcessingResourceMetaData md) {
        if (md == null) {
            return;
        }
        Capability[] capabilities = md.getCapabilities();
        if (capabilities == null) {
            return;
        }
        for (int i = 0; i < capabilities.length; ++i) {
            Capability c = capabilities[i];
            String[] languages = c.getLanguagesSupported();
            for (int j = 0; j < languages.length; ++j) {
                languages[j] = Language.normalize(languages[j]);
            }
        }
    }

    protected ConfigurationParameterSettings getCurrentConfigParameterSettings() {
        return this.getUimaContextAdmin().getConfigurationManager().getCurrentConfigParameterSettings(this.getUimaContextAdmin().getQualifiedContextName());
    }

    protected AnalysisEngineManagementImpl getMBean() {
        return (AnalysisEngineManagementImpl)this.getUimaContextAdmin().getManagementInterface();
    }

    protected void enterProcess() {
        this.mProcessTimer.startIt();
    }

    protected void exitProcess() {
        this.mProcessTimer.stopIt();
        this.getMBean().reportAnalysisTime(this.mProcessTimer.getDuration());
    }

    protected void enterBatchProcessComplete() {
        this.mProcessTimer.startIt();
    }

    protected void exitBatchProcessComplete() {
        this.mProcessTimer.stopIt();
        this.getMBean().reportBatchProcessCompleteTime(this.mProcessTimer.getDuration());
    }

    protected void enterCollectionProcessComplete() {
        this.mProcessTimer.startIt();
    }

    protected void exitCollectionProcessComplete() {
        this.mProcessTimer.stopIt();
        this.getMBean().reportCollectionProcessCompleteTime(this.mProcessTimer.getDuration());
    }

    protected ProcessTrace buildProcessTraceFromMBeanStats() {
        ProcessTrace_impl trace = new ProcessTrace_impl(this.getPerformanceTuningSettings());
        this.buildProcessTraceFromMBeanStats(trace);
        return trace;
    }

    protected void buildProcessTraceFromMBeanStats(ProcessTrace trace) {
        if (this.isProcessTraceEnabled()) {
            int analysisTime;
            int serviceCallTime = (int)this.getMBean().getServiceCallTimeSinceMark();
            ProcessTraceEvent_impl serviceCallEvent = null;
            if (serviceCallTime > 0) {
                serviceCallEvent = new ProcessTraceEvent_impl(this.getMetaData().getName(), "Service Call", "");
                serviceCallEvent.setDuration(serviceCallTime);
                trace.addEvent(serviceCallEvent);
            }
            if ((analysisTime = (int)this.getMBean().getAnalysisTimeSinceMark()) > 0 || analysisTime == 0 && serviceCallTime == 0) {
                ProcessTraceEvent_impl analysisEvent = new ProcessTraceEvent_impl(this.getMetaData().getName(), "Analysis", "");
                analysisEvent.setDuration(analysisTime);
                if (serviceCallEvent != null) {
                    serviceCallEvent.addSubEvent(analysisEvent);
                } else {
                    trace.addEvent(analysisEvent);
                }
            }
            this.getMBean().mark();
        }
    }

    protected boolean isProcessTraceEnabled() {
        return this.mProcessTraceEnabled;
    }

    protected Object getMBeanServer() {
        return this.mMBeanServer;
    }

    protected String getMBeanNamePrefix() {
        return this.mMBeanNamePrefix;
    }
}

