/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci.util;

import java.io.File;
import org.apache.uima.util.FileUtils;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;

public class VinciTAEClient {
    public static void main(String[] args) {
        System.out.println("Invoking the service...");
        try {
            VinciFrame response;
            String serviceName = args[0];
            VinciFrame query = new VinciFrame();
            if (args.length < 2) {
                query.fadd("vinci:COMMAND", "GetMeta");
                response = VinciClient.rpc(query, serviceName);
            } else {
                System.out.println("Analyzing Document...");
                File aFile = new File(args[1]);
                String fileData = FileUtils.file2String(aFile);
                VinciFrame data2 = new VinciFrame();
                VinciFrame key = new VinciFrame();
                key.fadd("Detag:DetagContent", fileData);
                data2.fadd("KEYS", key);
                query.fadd("vinci:COMMAND", "Annotate");
                query.fadd("DATA", data2);
                System.out.println(query.toXML());
                response = VinciClient.rpc(query, serviceName);
            }
            System.out.println("Response:\n" + response.toXML());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}

