/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.payloads.PayloadFunction;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.TermSpans;

public class PayloadTermQuery
extends SpanTermQuery {
    protected PayloadFunction function;
    private boolean includeSpanScore;

    public PayloadTermQuery(Term term, PayloadFunction function) {
        this(term, function, true);
    }

    public PayloadTermQuery(Term term, PayloadFunction function, boolean includeSpanScore) {
        super(term);
        this.function = function;
        this.includeSpanScore = includeSpanScore;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new PayloadTermWeight(this, searcher);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.function == null ? 0 : this.function.hashCode());
        result2 = 31 * result2 + (this.includeSpanScore ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayloadTermQuery other = (PayloadTermQuery)obj;
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        return this.includeSpanScore == other.includeSpanScore;
    }

    protected class PayloadTermWeight
    extends SpanWeight {
        public PayloadTermWeight(PayloadTermQuery query, Searcher searcher) throws IOException {
            super(query, searcher);
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new PayloadTermSpanScorer((TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }

        protected class PayloadTermSpanScorer
        extends SpanScorer {
            protected byte[] payload;
            protected TermPositions positions;
            protected float payloadScore;
            protected int payloadsSeen;

            public PayloadTermSpanScorer(TermSpans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
                super(spans, weight, similarity, norms);
                this.payload = new byte[256];
                this.positions = spans.getPositions();
            }

            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                Similarity similarity1 = this.getSimilarity();
                while (this.more && this.doc == this.spans.doc()) {
                    int matchLength = this.spans.end() - this.spans.start();
                    this.freq += similarity1.sloppyFreq(matchLength);
                    this.processPayload(similarity1);
                    this.more = this.spans.next();
                }
                return this.more || this.freq != 0.0f;
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.positions.isPayloadAvailable()) {
                    this.payload = this.positions.getPayload(this.payload, 0);
                    this.payloadScore = ((PayloadTermWeight)PayloadTermWeight.this).PayloadTermQuery.this.function.currentScore(this.doc, PayloadTermQuery.this.term.field(), this.spans.start(), this.spans.end(), this.payloadsSeen, this.payloadScore, similarity.scorePayload(this.doc, PayloadTermQuery.this.term.field(), this.spans.start(), this.spans.end(), this.payload, 0, this.positions.getPayloadLength()));
                    ++this.payloadsSeen;
                }
            }

            public float score() throws IOException {
                return PayloadTermQuery.this.includeSpanScore ? this.getSpanScore() * this.getPayloadScore() : this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.score();
            }

            protected float getPayloadScore() {
                return ((PayloadTermWeight)PayloadTermWeight.this).PayloadTermQuery.this.function.docScore(this.doc, PayloadTermQuery.this.term.field(), this.payloadsSeen, this.payloadScore);
            }

            public Explanation explain(int doc) throws IOException {
                ComplexExplanation result2 = new ComplexExplanation();
                Explanation nonPayloadExpl = super.explain(doc);
                result2.addDetail(nonPayloadExpl);
                Explanation payloadBoost = new Explanation();
                result2.addDetail(payloadBoost);
                float payloadScore = this.getPayloadScore();
                payloadBoost.setValue(payloadScore);
                payloadBoost.setDescription("scorePayload(...)");
                result2.setValue(nonPayloadExpl.getValue() * payloadScore);
                result2.setDescription("btq, product of:");
                result2.setMatch(nonPayloadExpl.getValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE);
                return result2;
            }
        }
    }
}

