/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class PayloadSpanUtil {
    private IndexReader reader;

    public PayloadSpanUtil(IndexReader reader) {
        this.reader = reader;
    }

    public Collection getPayloadsForQuery(Query query) throws IOException {
        ArrayList payloads = new ArrayList();
        this.queryToSpanQuery(query, payloads);
        return payloads;
    }

    private void queryToSpanQuery(Query query, Collection payloads) throws IOException {
        if (query instanceof BooleanQuery) {
            BooleanClause[] queryClauses = ((BooleanQuery)query).getClauses();
            for (int i = 0; i < queryClauses.length; ++i) {
                if (queryClauses[i].isProhibited()) continue;
                this.queryToSpanQuery(queryClauses[i].getQuery(), payloads);
            }
        } else if (query instanceof PhraseQuery) {
            Term[] phraseQueryTerms = ((PhraseQuery)query).getTerms();
            SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
            for (int i = 0; i < phraseQueryTerms.length; ++i) {
                clauses[i] = new SpanTermQuery(phraseQueryTerms[i]);
            }
            int slop = ((PhraseQuery)query).getSlop();
            boolean inorder = false;
            if (slop == 0) {
                inorder = true;
            }
            SpanNearQuery sp2 = new SpanNearQuery(clauses, slop, inorder);
            sp2.setBoost(query.getBoost());
            this.getPayloads(payloads, sp2);
        } else if (query instanceof TermQuery) {
            SpanTermQuery stq = new SpanTermQuery(((TermQuery)query).getTerm());
            stq.setBoost(query.getBoost());
            this.getPayloads(payloads, stq);
        } else if (query instanceof SpanQuery) {
            this.getPayloads(payloads, (SpanQuery)query);
        } else if (query instanceof FilteredQuery) {
            this.queryToSpanQuery(((FilteredQuery)query).getQuery(), payloads);
        } else if (query instanceof DisjunctionMaxQuery) {
            Iterator iterator2 = ((DisjunctionMaxQuery)query).iterator();
            while (iterator2.hasNext()) {
                this.queryToSpanQuery((Query)iterator2.next(), payloads);
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            List termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                for (int i = 0; i < positions.length - 1; ++i) {
                    if (positions[i] <= maxPosition) continue;
                    maxPosition = positions[i];
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                for (int i = 0; i < termArrays.size(); ++i) {
                    Term[] termArray = (Term[])termArrays.get(i);
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    for (int j = 0; j < termArray.length; ++j) {
                        disjuncts.add(new SpanTermQuery(termArray[j]));
                    }
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                for (int i = 0; i < disjunctLists.length; ++i) {
                    List disjuncts = disjunctLists[i];
                    if (disjuncts != null) {
                        clauses[position++] = new SpanOrQuery(disjuncts.toArray(new SpanQuery[disjuncts.size()]));
                        continue;
                    }
                    ++positionGaps;
                }
                int slop = mpq.getSlop();
                boolean inorder = slop == 0;
                SpanNearQuery sp3 = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                sp3.setBoost(query.getBoost());
                this.getPayloads(payloads, sp3);
            }
        }
    }

    private void getPayloads(Collection payloads, SpanQuery query) throws IOException {
        Spans spans = query.getSpans(this.reader);
        while (spans.next()) {
            if (!spans.isPayloadAvailable()) continue;
            Collection payload = spans.getPayload();
            Iterator it = payload.iterator();
            while (it.hasNext()) {
                byte[] bytes = (byte[])it.next();
                payloads.add(bytes);
            }
        }
    }
}

