/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;
import org.apache.lucene.util.ToStringUtils;

public class ValueSourceQuery
extends Query {
    ValueSource valSrc;

    public ValueSourceQuery(ValueSource valSrc) {
        this.valSrc = valSrc;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    public Weight createWeight(Searcher searcher) {
        return new ValueSourceWeight(searcher);
    }

    public String toString(String field2) {
        return this.valSrc.toString() + ToStringUtils.boost(this.getBoost());
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ValueSourceQuery other = (ValueSourceQuery)o;
        return this.getBoost() == other.getBoost() && this.valSrc.equals(other.valSrc);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.valSrc.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    private class ValueSourceScorer
    extends Scorer {
        private final ValueSourceWeight weight;
        private final float qWeight;
        private final DocValues vals;
        private final TermDocs termDocs;
        private int doc;

        private ValueSourceScorer(Similarity similarity, IndexReader reader, ValueSourceWeight w) throws IOException {
            super(similarity);
            this.doc = -1;
            this.weight = w;
            this.qWeight = w.getValue();
            this.vals = ValueSourceQuery.this.valSrc.getValues(reader);
            this.termDocs = reader.termDocs(null);
        }

        public boolean next() throws IOException {
            return this.termDocs.next();
        }

        public int nextDoc() throws IOException {
            this.doc = this.termDocs.next() ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        public int doc() {
            return this.termDocs.doc();
        }

        public int docID() {
            return this.doc;
        }

        public float score() throws IOException {
            return this.qWeight * this.vals.floatVal(this.termDocs.doc());
        }

        public boolean skipTo(int target) throws IOException {
            return this.termDocs.skipTo(target);
        }

        public int advance(int target) throws IOException {
            this.doc = this.termDocs.skipTo(target) ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            ComplexExplanation result2 = new ComplexExplanation(true, sc, ValueSourceQuery.this.toString() + ", product of:");
            result2.addDetail(this.vals.explain(doc));
            result2.addDetail(new Explanation(ValueSourceQuery.this.getBoost(), "boost"));
            result2.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result2;
        }
    }

    class ValueSourceWeight
    extends Weight {
        Similarity similarity;
        float queryNorm;
        float queryWeight;

        public ValueSourceWeight(Searcher searcher) {
            this.similarity = ValueSourceQuery.this.getSimilarity(searcher);
        }

        public Query getQuery() {
            return ValueSourceQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ValueSourceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new ValueSourceScorer(this.similarity, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new ValueSourceScorer(this.similarity, reader, this).explain(doc);
        }
    }
}

