/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.function.CustomScoreProvider;
import org.apache.lucene.search.function.ValueSourceQuery;
import org.apache.lucene.util.ToStringUtils;

public class CustomScoreQuery
extends Query {
    private Query subQuery;
    private ValueSourceQuery[] valSrcQueries;
    private boolean strict;

    public CustomScoreQuery(Query subQuery) {
        this(subQuery, new ValueSourceQuery[0]);
    }

    public CustomScoreQuery(Query subQuery, ValueSourceQuery valSrcQuery) {
        ValueSourceQuery[] valueSourceQueryArray;
        if (valSrcQuery != null) {
            ValueSourceQuery[] valueSourceQueryArray2 = new ValueSourceQuery[1];
            valueSourceQueryArray = valueSourceQueryArray2;
            valueSourceQueryArray2[0] = valSrcQuery;
        } else {
            valueSourceQueryArray = new ValueSourceQuery[]{};
        }
        this(subQuery, valueSourceQueryArray);
    }

    public CustomScoreQuery(Query subQuery, ValueSourceQuery[] valSrcQueries) {
        this.strict = false;
        this.subQuery = subQuery;
        ValueSourceQuery[] valueSourceQueryArray = this.valSrcQueries = valSrcQueries != null ? valSrcQueries : new ValueSourceQuery[]{};
        if (subQuery == null) {
            throw new IllegalArgumentException("<subquery> must not be null!");
        }
    }

    public Query rewrite(IndexReader reader) throws IOException {
        CustomScoreQuery clone2 = null;
        Query sq = this.subQuery.rewrite(reader);
        if (sq != this.subQuery) {
            clone2 = (CustomScoreQuery)this.clone();
            clone2.subQuery = sq;
        }
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            ValueSourceQuery v = (ValueSourceQuery)this.valSrcQueries[i].rewrite(reader);
            if (v == this.valSrcQueries[i]) continue;
            if (clone2 == null) {
                clone2 = (CustomScoreQuery)this.clone();
            }
            clone2.valSrcQueries[i] = v;
        }
        return clone2 == null ? this : clone2;
    }

    public void extractTerms(Set terms) {
        this.subQuery.extractTerms(terms);
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            this.valSrcQueries[i].extractTerms(terms);
        }
    }

    public Object clone() {
        CustomScoreQuery clone2 = (CustomScoreQuery)super.clone();
        clone2.subQuery = (Query)this.subQuery.clone();
        clone2.valSrcQueries = new ValueSourceQuery[this.valSrcQueries.length];
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            clone2.valSrcQueries[i] = (ValueSourceQuery)this.valSrcQueries[i].clone();
        }
        return clone2;
    }

    public String toString(String field2) {
        StringBuffer sb = new StringBuffer(this.name()).append("(");
        sb.append(this.subQuery.toString(field2));
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            sb.append(", ").append(this.valSrcQueries[i].toString(field2));
        }
        sb.append(")");
        sb.append(this.strict ? " STRICT" : "");
        return sb.toString() + ToStringUtils.boost(this.getBoost());
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CustomScoreQuery other = (CustomScoreQuery)o;
        if (this.getBoost() != other.getBoost() || !this.subQuery.equals(other.subQuery) || this.strict != other.strict || this.valSrcQueries.length != other.valSrcQueries.length) {
            return false;
        }
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            if (this.valSrcQueries[i].equals(other.valSrcQueries[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int valSrcHash = 0;
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            valSrcHash += this.valSrcQueries[i].hashCode();
        }
        return this.getClass().hashCode() + this.subQuery.hashCode() + valSrcHash ^ Float.floatToIntBits(this.getBoost()) ^ (this.strict ? 1234 : 4321);
    }

    protected CustomScoreProvider getCustomScoreProvider(IndexReader reader) throws IOException {
        return new CustomScoreProvider(reader){

            public float customScore(int doc, float subQueryScore, float[] valSrcScores) throws IOException {
                return CustomScoreQuery.this.customScore(doc, subQueryScore, valSrcScores);
            }

            public float customScore(int doc, float subQueryScore, float valSrcScore) throws IOException {
                return CustomScoreQuery.this.customScore(doc, subQueryScore, valSrcScore);
            }

            public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation[] valSrcExpls) throws IOException {
                return CustomScoreQuery.this.customExplain(doc, subQueryExpl, valSrcExpls);
            }

            public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation valSrcExpl) throws IOException {
                return CustomScoreQuery.this.customExplain(doc, subQueryExpl, valSrcExpl);
            }
        };
    }

    public float customScore(int doc, float subQueryScore, float[] valSrcScores) {
        if (valSrcScores.length == 1) {
            return this.customScore(doc, subQueryScore, valSrcScores[0]);
        }
        if (valSrcScores.length == 0) {
            return this.customScore(doc, subQueryScore, 1.0f);
        }
        float score = subQueryScore;
        for (int i = 0; i < valSrcScores.length; ++i) {
            score *= valSrcScores[i];
        }
        return score;
    }

    public float customScore(int doc, float subQueryScore, float valSrcScore) {
        return subQueryScore * valSrcScore;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation[] valSrcExpls) {
        if (valSrcExpls.length == 1) {
            return this.customExplain(doc, subQueryExpl, valSrcExpls[0]);
        }
        if (valSrcExpls.length == 0) {
            return subQueryExpl;
        }
        float valSrcScore = 1.0f;
        for (int i = 0; i < valSrcExpls.length; ++i) {
            valSrcScore *= valSrcExpls[i].getValue();
        }
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        for (int i = 0; i < valSrcExpls.length; ++i) {
            exp.addDetail(valSrcExpls[i]);
        }
        return exp;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation valSrcExpl) {
        float valSrcScore = 1.0f;
        if (valSrcExpl != null) {
            valSrcScore *= valSrcExpl.getValue();
        }
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        exp.addDetail(valSrcExpl);
        return exp;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new CustomWeight(searcher);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String name() {
        return "custom";
    }

    private class CustomScorer
    extends Scorer {
        private final CustomWeight weight;
        private final float qWeight;
        private Scorer subQueryScorer;
        private Scorer[] valSrcScorers;
        private IndexReader reader;
        private final CustomScoreProvider provider;
        private float[] vScores;

        private CustomScorer(Similarity similarity, IndexReader reader, CustomWeight w, Scorer subQueryScorer, Scorer[] valSrcScorers) throws IOException {
            super(similarity);
            this.weight = w;
            this.qWeight = w.getValue();
            this.subQueryScorer = subQueryScorer;
            this.valSrcScorers = valSrcScorers;
            this.reader = reader;
            this.vScores = new float[valSrcScorers.length];
            this.provider = CustomScoreQuery.this.getCustomScoreProvider(reader);
        }

        public boolean next() throws IOException {
            return this.nextDoc() != Integer.MAX_VALUE;
        }

        public int nextDoc() throws IOException {
            int doc = this.subQueryScorer.nextDoc();
            if (doc != Integer.MAX_VALUE) {
                for (int i = 0; i < this.valSrcScorers.length; ++i) {
                    this.valSrcScorers[i].advance(doc);
                }
            }
            return doc;
        }

        public int doc() {
            return this.subQueryScorer.doc();
        }

        public int docID() {
            return this.subQueryScorer.docID();
        }

        public float score() throws IOException {
            for (int i = 0; i < this.valSrcScorers.length; ++i) {
                this.vScores[i] = this.valSrcScorers[i].score();
            }
            return this.qWeight * this.provider.customScore(this.subQueryScorer.docID(), this.subQueryScorer.score(), this.vScores);
        }

        public boolean skipTo(int target) throws IOException {
            return this.advance(target) != Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            int doc = this.subQueryScorer.advance(target);
            if (doc != Integer.MAX_VALUE) {
                for (int i = 0; i < this.valSrcScorers.length; ++i) {
                    this.valSrcScorers[i].advance(doc);
                }
            }
            return doc;
        }

        public Explanation explain(int doc) throws IOException {
            Explanation subQueryExpl = this.weight.subQueryWeight.explain(this.reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            Explanation[] valSrcExpls = new Explanation[this.valSrcScorers.length];
            for (int i = 0; i < this.valSrcScorers.length; ++i) {
                valSrcExpls[i] = this.valSrcScorers[i].explain(doc);
            }
            Explanation customExp = CustomScoreQuery.this.customExplain(doc, subQueryExpl, valSrcExpls);
            float sc = this.qWeight * customExp.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, CustomScoreQuery.this.toString() + ", product of:");
            res.addDetail(customExp);
            res.addDetail(new Explanation(this.qWeight, "queryBoost"));
            return res;
        }
    }

    private class CustomWeight
    extends Weight {
        Similarity similarity;
        Weight subQueryWeight;
        Weight[] valSrcWeights;
        boolean qStrict;

        public CustomWeight(Searcher searcher) throws IOException {
            this.similarity = CustomScoreQuery.this.getSimilarity(searcher);
            this.subQueryWeight = CustomScoreQuery.this.subQuery.weight(searcher);
            this.valSrcWeights = new Weight[CustomScoreQuery.this.valSrcQueries.length];
            for (int i = 0; i < CustomScoreQuery.this.valSrcQueries.length; ++i) {
                this.valSrcWeights[i] = CustomScoreQuery.this.valSrcQueries[i].createWeight(searcher);
            }
            this.qStrict = CustomScoreQuery.this.strict;
        }

        public Query getQuery() {
            return CustomScoreQuery.this;
        }

        public float getValue() {
            return CustomScoreQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum2 = this.subQueryWeight.sumOfSquaredWeights();
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                if (this.qStrict) {
                    this.valSrcWeights[i].sumOfSquaredWeights();
                    continue;
                }
                sum2 += this.valSrcWeights[i].sumOfSquaredWeights();
            }
            return sum2 *= CustomScoreQuery.this.getBoost() * CustomScoreQuery.this.getBoost();
        }

        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= CustomScoreQuery.this.getBoost());
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                if (this.qStrict) {
                    this.valSrcWeights[i].normalize(1.0f);
                    continue;
                }
                this.valSrcWeights[i].normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader, true, false);
            if (subQueryScorer == null) {
                return null;
            }
            Scorer[] valSrcScorers = new Scorer[this.valSrcWeights.length];
            for (int i = 0; i < valSrcScorers.length; ++i) {
                valSrcScorers[i] = this.valSrcWeights[i].scorer(reader, true, topScorer);
            }
            return new CustomScorer(this.similarity, reader, this, subQueryScorer, valSrcScorers);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation explain = this.doExplain(reader, doc);
            return explain == null ? new Explanation(0.0f, "no matching docs") : this.doExplain(reader, doc);
        }

        private Explanation doExplain(IndexReader reader, int doc) throws IOException {
            Scorer[] valSrcScorers = new Scorer[this.valSrcWeights.length];
            for (int i = 0; i < valSrcScorers.length; ++i) {
                valSrcScorers[i] = this.valSrcWeights[i].scorer(reader, true, false);
            }
            Explanation subQueryExpl = this.subQueryWeight.explain(reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            Explanation[] valSrcExpls = new Explanation[valSrcScorers.length];
            for (int i = 0; i < valSrcScorers.length; ++i) {
                valSrcExpls[i] = valSrcScorers[i].explain(doc);
            }
            Explanation customExp = CustomScoreQuery.this.getCustomScoreProvider(reader).customExplain(doc, subQueryExpl, valSrcExpls);
            float sc = this.getValue() * customExp.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, CustomScoreQuery.this.toString() + ", product of:");
            res.addDetail(customExp);
            res.addDetail(new Explanation(this.getValue(), "queryBoost"));
            return res;
        }

        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

