/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class ByteFieldSource
extends FieldCacheSource {
    private FieldCache.ByteParser parser;

    public ByteFieldSource(String field2) {
        this(field2, null);
    }

    public ByteFieldSource(String field2, FieldCache.ByteParser parser) {
        super(field2);
        this.parser = parser;
    }

    public String description() {
        return "byte(" + super.description() + ')';
    }

    public DocValues getCachedFieldValues(FieldCache cache, String field2, IndexReader reader) throws IOException {
        final byte[] arr = cache.getBytes(reader, field2, this.parser);
        return new DocValues(){

            public float floatVal(int doc) {
                return arr[doc];
            }

            public int intVal(int doc) {
                return arr[doc];
            }

            public String toString(int doc) {
                return ByteFieldSource.this.description() + '=' + this.intVal(doc);
            }

            Object getInnerArray() {
                return arr;
            }
        };
    }

    public boolean cachedFieldSourceEquals(FieldCacheSource o) {
        if (o.getClass() != ByteFieldSource.class) {
            return false;
        }
        ByteFieldSource other = (ByteFieldSource)o;
        return this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Byte.class.hashCode() : this.parser.getClass().hashCode();
    }
}

