/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class TermQuery
extends Query {
    private Term term;

    public TermQuery(Term t) {
        this.term = t;
    }

    public Term getTerm() {
        return this.term;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new TermWeight(searcher);
    }

    public void extractTerms(Set terms) {
        terms.add(this.getTerm());
    }

    public String toString(String field2) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field2)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermQuery)) {
            return false;
        }
        TermQuery other = (TermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode();
    }

    private class TermWeight
    extends Weight {
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public TermWeight(Searcher searcher) throws IOException {
            this.similarity = TermQuery.this.getSimilarity(searcher);
            this.idfExp = this.similarity.idfExplain(TermQuery.this.term, searcher);
            this.idf = this.idfExp.getIdf();
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        public Query getQuery() {
            return TermQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * TermQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            TermDocs termDocs = reader.termDocs(TermQuery.this.term);
            if (termDocs == null) {
                return null;
            }
            return new TermScorer(this, termDocs, this.similarity, reader.norms(TermQuery.this.term.field()));
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            ComplexExplanation result2 = new ComplexExplanation();
            result2.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation expl2 = new Explanation(this.idf, this.idfExp.explain());
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(TermQuery.this.getBoost(), "boost");
            if (TermQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(expl2);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * expl2.getValue() * queryNormExpl.getValue());
            result2.addDetail(queryExpl);
            String field2 = TermQuery.this.term.field();
            ComplexExplanation fieldExpl = new ComplexExplanation();
            fieldExpl.setDescription("fieldWeight(" + TermQuery.this.term + " in " + doc + "), product of:");
            Explanation tfExpl = this.scorer(reader, true, false).explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(expl2);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(field2);
            float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 1.0f;
            fieldNormExpl.setValue(fieldNorm);
            fieldNormExpl.setDescription("fieldNorm(field=" + field2 + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setMatch(tfExpl.isMatch());
            fieldExpl.setValue(tfExpl.getValue() * expl2.getValue() * fieldNormExpl.getValue());
            result2.addDetail(fieldExpl);
            result2.setMatch(fieldExpl.getMatch());
            result2.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result2;
        }
    }
}

