/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ToStringUtils;

public final class NumericRangeQuery
extends MultiTermQuery {
    String field;
    final int precisionStep;
    final int valSize;
    final Number min;
    final Number max;
    final boolean minInclusive;
    final boolean maxInclusive;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NumericRangeQuery(String field2, int precisionStep, int valSize, Number min2, Number max2, boolean minInclusive, boolean maxInclusive) {
        if (!$assertionsDisabled && valSize != 32 && valSize != 64) {
            throw new AssertionError();
        }
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.field = StringHelper.intern(field2);
        this.precisionStep = precisionStep;
        this.valSize = valSize;
        this.min = min2;
        this.max = max2;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        switch (valSize) {
            case 64: {
                this.setRewriteMethod(precisionStep > 6 ? CONSTANT_SCORE_FILTER_REWRITE : CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                break;
            }
            case 32: {
                this.setRewriteMethod(precisionStep > 8 ? CONSTANT_SCORE_FILTER_REWRITE : CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                break;
            }
            default: {
                throw new IllegalArgumentException("valSize must be 32 or 64");
            }
        }
        if (min2 != null && min2.equals(max2)) {
            this.setRewriteMethod(CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
        }
    }

    public static NumericRangeQuery newLongRange(String field2, int precisionStep, Long min2, Long max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, precisionStep, 64, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newLongRange(String field2, Long min2, Long max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, 4, 64, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newIntRange(String field2, int precisionStep, Integer min2, Integer max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, precisionStep, 32, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newIntRange(String field2, Integer min2, Integer max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, 4, 32, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newDoubleRange(String field2, int precisionStep, Double min2, Double max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, precisionStep, 64, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newDoubleRange(String field2, Double min2, Double max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, 4, 64, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newFloatRange(String field2, int precisionStep, Float min2, Float max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, precisionStep, 32, min2, max2, minInclusive, maxInclusive);
    }

    public static NumericRangeQuery newFloatRange(String field2, Float min2, Float max2, boolean minInclusive, boolean maxInclusive) {
        return new NumericRangeQuery(field2, 4, 32, min2, max2, minInclusive, maxInclusive);
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new NumericRangeTermEnum(reader);
    }

    public String getField() {
        return this.field;
    }

    public boolean includesMin() {
        return this.minInclusive;
    }

    public boolean includesMax() {
        return this.maxInclusive;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    public String toString(String field2) {
        StringBuffer sb = new StringBuffer();
        if (!this.field.equals(field2)) {
            sb.append(this.field).append(':');
        }
        return sb.append(this.minInclusive ? (char)'[' : '{').append(this.min == null ? "*" : this.min.toString()).append(" TO ").append(this.max == null ? "*" : this.max.toString()).append(this.maxInclusive ? (char)']' : '}').append(ToStringUtils.boost(this.getBoost())).toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof NumericRangeQuery) {
            NumericRangeQuery q = (NumericRangeQuery)o;
            return this.field == q.field && (q.min == null ? this.min == null : q.min.equals(this.min)) && (q.max == null ? this.max == null : q.max.equals(this.max)) && this.minInclusive == q.minInclusive && this.maxInclusive == q.maxInclusive && this.precisionStep == q.precisionStep;
        }
        return false;
    }

    public final int hashCode() {
        int hash = super.hashCode();
        hash += this.field.hashCode() ^ 1164311910 + this.precisionStep ^ 0x64365465;
        if (this.min != null) {
            hash += this.min.hashCode() ^ 0x14FA55FB;
        }
        if (this.max != null) {
            hash += this.max.hashCode() ^ 0x733FA5FE;
        }
        return hash + (Boolean.valueOf(this.minInclusive).hashCode() ^ 0x14FA55FB) + (Boolean.valueOf(this.maxInclusive).hashCode() ^ 0x733FA5FE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.field = StringHelper.intern(this.field);
    }

    static {
        $assertionsDisabled = !NumericRangeQuery.class.desiredAssertionStatus();
    }

    private final class NumericRangeTermEnum
    extends FilteredTermEnum {
        private final IndexReader reader;
        private final LinkedList rangeBounds = new LinkedList();
        private String currentUpperBound = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        NumericRangeTermEnum(IndexReader reader) throws IOException {
            this.reader = reader;
            switch (NumericRangeQuery.this.valSize) {
                case 64: {
                    long minBound = Long.MIN_VALUE;
                    if (NumericRangeQuery.this.min instanceof Long) {
                        minBound = NumericRangeQuery.this.min.longValue();
                    } else if (NumericRangeQuery.this.min instanceof Double) {
                        minBound = NumericUtils.doubleToSortableLong(NumericRangeQuery.this.min.doubleValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (minBound == Long.MAX_VALUE) break;
                        ++minBound;
                    }
                    long maxBound = Long.MAX_VALUE;
                    if (NumericRangeQuery.this.max instanceof Long) {
                        maxBound = NumericRangeQuery.this.max.longValue();
                    } else if (NumericRangeQuery.this.max instanceof Double) {
                        maxBound = NumericUtils.doubleToSortableLong(NumericRangeQuery.this.max.doubleValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (maxBound == Long.MIN_VALUE) break;
                        --maxBound;
                    }
                    NumericUtils.splitLongRange(new NumericUtils.LongRangeBuilder(){

                        public final void addRange(String minPrefixCoded, String maxPrefixCoded) {
                            NumericRangeTermEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, NumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                case 32: {
                    int minBound = Integer.MIN_VALUE;
                    if (NumericRangeQuery.this.min instanceof Integer) {
                        minBound = NumericRangeQuery.this.min.intValue();
                    } else if (NumericRangeQuery.this.min instanceof Float) {
                        minBound = NumericUtils.floatToSortableInt(NumericRangeQuery.this.min.floatValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (minBound == Integer.MAX_VALUE) break;
                        ++minBound;
                    }
                    int maxBound = Integer.MAX_VALUE;
                    if (NumericRangeQuery.this.max instanceof Integer) {
                        maxBound = NumericRangeQuery.this.max.intValue();
                    } else if (NumericRangeQuery.this.max instanceof Float) {
                        maxBound = NumericUtils.floatToSortableInt(NumericRangeQuery.this.max.floatValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (maxBound == Integer.MIN_VALUE) break;
                        --maxBound;
                    }
                    NumericUtils.splitIntRange(new NumericUtils.IntRangeBuilder(){

                        public final void addRange(String minPrefixCoded, String maxPrefixCoded) {
                            NumericRangeTermEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, NumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("valSize must be 32 or 64");
                }
            }
            this.next();
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return this.currentTerm != null;
        }

        protected boolean termCompare(Term term) {
            return term.field() == NumericRangeQuery.this.field && term.text().compareTo(this.currentUpperBound) <= 0;
        }

        public boolean next() throws IOException {
            if (this.currentTerm != null) {
                if (!$assertionsDisabled && this.actualEnum == null) {
                    throw new AssertionError();
                }
                if (this.actualEnum.next()) {
                    this.currentTerm = this.actualEnum.term();
                    if (this.termCompare(this.currentTerm)) {
                        return true;
                    }
                }
            }
            this.currentTerm = null;
            if (this.rangeBounds.size() < 2) {
                return false;
            }
            if (this.actualEnum != null) {
                this.actualEnum.close();
                this.actualEnum = null;
            }
            String lowerBound = (String)this.rangeBounds.removeFirst();
            this.currentUpperBound = (String)this.rangeBounds.removeFirst();
            this.setEnum(this.reader.terms(new Term(NumericRangeQuery.this.field, lowerBound)));
            return this.currentTerm != null;
        }

        public void close() throws IOException {
            this.rangeBounds.clear();
            this.currentUpperBound = null;
            super.close();
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$search$NumericRangeQuery == null ? (class$org$apache$lucene$search$NumericRangeQuery = NumericRangeQuery.class$("org.apache.lucene.search.NumericRangeQuery")) : class$org$apache$lucene$search$NumericRangeQuery).desiredAssertionStatus();
        }
    }
}

