/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollectorWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ReaderUtil;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;
    private IndexReader[] subReaders;
    private int[] docStarts;
    private boolean fieldSortDoTrackScores;
    private boolean fieldSortDoMaxScore;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexSearcher(String path) throws CorruptIndexException, IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(String path, boolean readOnly) throws CorruptIndexException, IOException {
        this(IndexReader.open(path, readOnly), true);
    }

    public IndexSearcher(Directory directory) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(Directory path, boolean readOnly) throws CorruptIndexException, IOException {
        this(IndexReader.open(path, readOnly), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
        ArrayList subReadersList = new ArrayList();
        this.gatherSubReaders(subReadersList, this.reader);
        this.subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        this.docStarts = new int[this.subReaders.length];
        int maxDoc = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.docStarts[i] = maxDoc;
            maxDoc += this.subReaders[i].maxDoc();
        }
    }

    protected void gatherSubReaders(List allSubReaders, IndexReader r) {
        ReaderUtil.gatherSubReaders(allSubReaders, r);
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.reader.document(i);
    }

    public Document doc(int i, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(i, fieldSelector);
    }

    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    public TopDocs search(Weight weight, Filter filter2, int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        nDocs = Math.min(nDocs, this.reader.maxDoc());
        TopScoreDocCollector collector = TopScoreDocCollector.create(nDocs, !weight.scoresDocsOutOfOrder());
        this.search(weight, filter2, (Collector)collector);
        return collector.topDocs();
    }

    public TopFieldDocs search(Weight weight, Filter filter2, int nDocs, Sort sort2) throws IOException {
        return this.search(weight, filter2, nDocs, sort2, true);
    }

    public TopFieldDocs search(Weight weight, Filter filter2, int nDocs, Sort sort2, boolean fillFields) throws IOException {
        nDocs = Math.min(nDocs, this.reader.maxDoc());
        SortField[] fields = sort2.fields;
        boolean legacy = false;
        for (int i = 0; i < fields.length; ++i) {
            SortField field2 = fields[i];
            String fieldname = field2.getField();
            int type = field2.getType();
            if (type == 2) {
                int autotype = SortField.detectFieldType(this.reader, fieldname);
                fields[i] = autotype == 3 ? new SortField(fieldname, field2.getLocale(), field2.getReverse()) : new SortField(fieldname, autotype, field2.getReverse());
            }
            if (!field2.getUseLegacySearch()) continue;
            legacy = true;
        }
        if (legacy) {
            TopFieldDocCollector collector = new TopFieldDocCollector(this.reader, sort2, nDocs);
            HitCollectorWrapper hcw = new HitCollectorWrapper(collector);
            hcw.setNextReader(this.reader, 0);
            if (filter2 == null) {
                Scorer scorer = weight.scorer(this.reader, true, true);
                if (scorer != null) {
                    scorer.score(hcw);
                }
            } else {
                this.searchWithFilter(this.reader, weight, filter2, hcw);
            }
            return (TopFieldDocs)((TopDocCollector)collector).topDocs();
        }
        TopFieldCollector collector = TopFieldCollector.create(sort2, nDocs, fillFields, this.fieldSortDoTrackScores, this.fieldSortDoMaxScore, !weight.scoresDocsOutOfOrder());
        this.search(weight, filter2, (Collector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    public void search(Weight weight, Filter filter2, Collector collector) throws IOException {
        if (filter2 == null) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                collector.setNextReader(this.subReaders[i], this.docStarts[i]);
                Scorer scorer = weight.scorer(this.subReaders[i], !collector.acceptsDocsOutOfOrder(), true);
                if (scorer == null) continue;
                scorer.score(collector);
            }
        } else {
            for (int i = 0; i < this.subReaders.length; ++i) {
                collector.setNextReader(this.subReaders[i], this.docStarts[i]);
                this.searchWithFilter(this.subReaders[i], weight, filter2, collector);
            }
        }
    }

    private void searchWithFilter(IndexReader reader, Weight weight, Filter filter2, Collector collector) throws IOException {
        if (!$assertionsDisabled && filter2 == null) {
            throw new AssertionError();
        }
        Scorer scorer = weight.scorer(reader, true, false);
        if (scorer == null) {
            return;
        }
        int docID = scorer.docID();
        if (!$assertionsDisabled && docID != -1 && docID != Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        DocIdSet filterDocIdSet = filter2.getDocIdSet(reader);
        if (filterDocIdSet == null) {
            return;
        }
        DocIdSetIterator filterIter = filterDocIdSet.iterator();
        if (filterIter == null) {
            return;
        }
        int filterDoc = filterIter.nextDoc();
        int scorerDoc = scorer.advance(filterDoc);
        collector.setScorer(scorer);
        while (true) {
            if (scorerDoc == filterDoc) {
                if (scorerDoc == Integer.MAX_VALUE) break;
                collector.collect(scorerDoc);
                filterDoc = filterIter.nextDoc();
                scorerDoc = scorer.advance(filterDoc);
                continue;
            }
            if (scorerDoc > filterDoc) {
                filterDoc = filterIter.advance(scorerDoc);
                continue;
            }
            scorerDoc = scorer.advance(filterDoc);
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.docStarts);
        int deBasedDoc = doc - this.docStarts[n];
        return weight.explain(this.subReaders[n], deBasedDoc);
    }

    public void setDefaultFieldSortScoring(boolean doTrackScores, boolean doMaxScore) {
        this.fieldSortDoTrackScores = doTrackScores;
        this.fieldSortDoMaxScore = doMaxScore;
    }

    static {
        $assertionsDisabled = !IndexSearcher.class.desiredAssertionStatus();
    }
}

