/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ToStringUtils;

public class FuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 0.5f;
    public static final int defaultPrefixLength = 0;
    private float minimumSimilarity;
    private int prefixLength;
    private boolean termLongEnough = false;
    protected Term term;

    public FuzzyQuery(Term term, float minimumSimilarity, int prefixLength) throws IllegalArgumentException {
        super(term);
        this.term = term;
        if (minimumSimilarity >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity >= 1");
        }
        if (minimumSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        if ((float)term.text().length() > 1.0f / (1.0f - minimumSimilarity)) {
            this.termLongEnough = true;
        }
        this.minimumSimilarity = minimumSimilarity;
        this.prefixLength = prefixLength;
        this.rewriteMethod = SCORING_BOOLEAN_QUERY_REWRITE;
    }

    public FuzzyQuery(Term term, float minimumSimilarity) throws IllegalArgumentException {
        this(term, minimumSimilarity, 0);
    }

    public FuzzyQuery(Term term) {
        this(term, 0.5f, 0);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new FuzzyTermEnum(reader, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    public Term getTerm() {
        return this.term;
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("FuzzyQuery cannot change rewrite method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        if (!this.termLongEnough) {
            return new TermQuery(this.term);
        }
        FilteredTermEnum enumerator = this.getEnum(reader);
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        ScoreTermQueue stQueue = new ScoreTermQueue(maxClauseCount);
        ScoreTerm reusableST = null;
        try {
            do {
                float score = 0.0f;
                Term t = enumerator.term();
                if (t == null) continue;
                score = enumerator.difference();
                if (reusableST == null) {
                    reusableST = new ScoreTerm(t, score);
                } else {
                    if (!(score >= reusableST.score)) continue;
                    reusableST.score = score;
                    reusableST.term = t;
                }
                reusableST = (ScoreTerm)stQueue.insertWithOverflow(reusableST);
            } while (enumerator.next());
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            enumerator.close();
            throw throwable;
        }
        enumerator.close();
        BooleanQuery query = new BooleanQuery(true);
        int size2 = stQueue.size();
        for (int i = 0; i < size2; ++i) {
            ScoreTerm st = (ScoreTerm)stQueue.pop();
            TermQuery tq = new TermQuery(st.term);
            tq.setBoost(this.getBoost() * st.score);
            query.add(tq, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    public String toString(String field2) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field2)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('~');
        buffer.append(Float.toString(this.minimumSimilarity));
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Float.floatToIntBits(this.minimumSimilarity);
        result2 = 31 * result2 + this.prefixLength;
        result2 = 31 * result2 + (this.term == null ? 0 : this.term.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyQuery other = (FuzzyQuery)obj;
        if (Float.floatToIntBits(this.minimumSimilarity) != Float.floatToIntBits(other.minimumSimilarity)) {
            return false;
        }
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    protected static class ScoreTermQueue
    extends PriorityQueue {
        public ScoreTermQueue(int size2) {
            this.initialize(size2);
        }

        protected boolean lessThan(Object a, Object b) {
            ScoreTerm termA = (ScoreTerm)a;
            ScoreTerm termB = (ScoreTerm)b;
            if (termA.score == termB.score) {
                return termA.term.compareTo(termB.term) > 0;
            }
            return termA.score < termB.score;
        }
    }

    protected static class ScoreTerm {
        public Term term;
        public float score;

        public ScoreTerm(Term term, float score) {
            this.term = term;
            this.score = score;
        }
    }
}

