/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.lucene.search.Filter;

public class FilterManager {
    protected static FilterManager manager;
    protected static final int DEFAULT_CACHE_CLEAN_SIZE = 100;
    protected static final long DEFAULT_CACHE_SLEEP_TIME = 600000L;
    protected Map cache = new HashMap();
    protected int cacheCleanSize = 100;
    protected long cleanSleepTime = 600000L;
    protected FilterCleaner filterCleaner = new FilterCleaner();

    public static synchronized FilterManager getInstance() {
        if (manager == null) {
            manager = new FilterManager();
        }
        return manager;
    }

    protected FilterManager() {
        Thread fcThread = new Thread(this.filterCleaner);
        fcThread.setDaemon(true);
        fcThread.start();
    }

    public void setCacheSize(int cacheCleanSize) {
        this.cacheCleanSize = cacheCleanSize;
    }

    public void setCleanThreadSleepTime(long cleanSleepTime) {
        this.cleanSleepTime = cleanSleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter(Filter filter2) {
        Map map2 = this.cache;
        synchronized (map2) {
            FilterItem fi = null;
            fi = (FilterItem)this.cache.get(new Integer(filter2.hashCode()));
            if (fi != null) {
                fi.timestamp = new Date().getTime();
                return fi.filter;
            }
            this.cache.put(new Integer(filter2.hashCode()), new FilterItem(filter2));
            return filter2;
        }
    }

    protected class FilterCleaner
    implements Runnable {
        private boolean running = true;
        private TreeSet sortedFilterItems;

        public FilterCleaner() {
            this.sortedFilterItems = new TreeSet(new Comparator(){

                public int compare(Object a, Object b) {
                    if (a instanceof Map.Entry && b instanceof Map.Entry) {
                        FilterItem fia = (FilterItem)((Map.Entry)a).getValue();
                        FilterItem fib = (FilterItem)((Map.Entry)b).getValue();
                        if (fia.timestamp == fib.timestamp) {
                            return 0;
                        }
                        if (fia.timestamp < fib.timestamp) {
                            return -1;
                        }
                        return 1;
                    }
                    throw new ClassCastException("Objects are not Map.Entry");
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                if (FilterManager.this.cache.size() > FilterManager.this.cacheCleanSize) {
                    this.sortedFilterItems.clear();
                    Map map2 = FilterManager.this.cache;
                    synchronized (map2) {
                        this.sortedFilterItems.addAll(FilterManager.this.cache.entrySet());
                        Iterator it = this.sortedFilterItems.iterator();
                        int numToDelete = (int)((double)(FilterManager.this.cache.size() - FilterManager.this.cacheCleanSize) * 1.5);
                        int counter = 0;
                        while (it.hasNext() && counter++ < numToDelete) {
                            Map.Entry entry = (Map.Entry)it.next();
                            FilterManager.this.cache.remove(entry.getKey());
                        }
                    }
                    this.sortedFilterItems.clear();
                }
                try {
                    Thread.sleep(FilterManager.this.cleanSleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }
    }

    protected class FilterItem {
        public Filter filter;
        public long timestamp;

        public FilterItem(Filter filter2) {
            this.filter = filter2;
            this.timestamp = new Date().getTime();
        }
    }
}

