/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class ConstantScoreQuery
extends Query {
    protected final Filter filter;

    public ConstantScoreQuery(Filter filter2) {
        this.filter = filter2;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    public Weight createWeight(Searcher searcher) {
        return new ConstantWeight(searcher);
    }

    public String toString(String field2) {
        return "ConstantScore(" + this.filter.toString() + ((double)this.getBoost() == 1.0 ? ")" : "^" + this.getBoost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantScoreQuery)) {
            return false;
        }
        ConstantScoreQuery other = (ConstantScoreQuery)o;
        return this.getBoost() == other.getBoost() && this.filter.equals(other.filter);
    }

    public int hashCode() {
        return this.filter.hashCode() + Float.floatToIntBits(this.getBoost());
    }

    protected class ConstantScorer
    extends Scorer {
        final DocIdSetIterator docIdSetIterator;
        final float theScore;
        int doc;

        public ConstantScorer(Similarity similarity, IndexReader reader, Weight w) throws IOException {
            DocIdSetIterator iter2;
            super(similarity);
            this.doc = -1;
            this.theScore = w.getValue();
            DocIdSet docIdSet = ConstantScoreQuery.this.filter.getDocIdSet(reader);
            this.docIdSetIterator = docIdSet == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : ((iter2 = docIdSet.iterator()) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : iter2);
        }

        public boolean next() throws IOException {
            return this.docIdSetIterator.nextDoc() != Integer.MAX_VALUE;
        }

        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        public int doc() {
            return this.docIdSetIterator.doc();
        }

        public int docID() {
            return this.docIdSetIterator.docID();
        }

        public float score() throws IOException {
            return this.theScore;
        }

        public boolean skipTo(int target) throws IOException {
            return this.docIdSetIterator.advance(target) != Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return this.docIdSetIterator.advance(target);
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class ConstantWeight
    extends Weight {
        private Similarity similarity;
        private float queryNorm;
        private float queryWeight;

        public ConstantWeight(Searcher searcher) {
            this.similarity = ConstantScoreQuery.this.getSimilarity(searcher);
        }

        public Query getQuery() {
            return ConstantScoreQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new ConstantScorer(this.similarity, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            ConstantScorer cs = new ConstantScorer(this.similarity, reader, this);
            boolean exists2 = cs.docIdSetIterator.advance(doc) == doc;
            ComplexExplanation result2 = new ComplexExplanation();
            if (exists2) {
                result2.setDescription("ConstantScoreQuery(" + ConstantScoreQuery.this.filter + "), product of:");
                result2.setValue(this.queryWeight);
                result2.setMatch(Boolean.TRUE);
                result2.addDetail(new Explanation(ConstantScoreQuery.this.getBoost(), "boost"));
                result2.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result2.setDescription("ConstantScoreQuery(" + ConstantScoreQuery.this.filter + ") doesn't match id " + doc);
                result2.setValue(0.0f);
                result2.setMatch(Boolean.FALSE);
            }
            return result2;
        }
    }
}

