/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ParallelArrayTermVectorMapper;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;

class TermVectorsReader
implements Cloneable {
    static final int FORMAT_VERSION = 2;
    static final int FORMAT_VERSION2 = 3;
    static final int FORMAT_UTF8_LENGTH_IN_BYTES = 4;
    static final int FORMAT_CURRENT = 4;
    static final int FORMAT_SIZE = 4;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 1;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 2;
    private FieldInfos fieldInfos;
    private IndexInput tvx;
    private IndexInput tvd;
    private IndexInput tvf;
    private int size;
    private int numTotalDocs;
    private int docStoreOffset;
    private final int format;
    static final /* synthetic */ boolean $assertionsDisabled;

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos) throws CorruptIndexException, IOException {
        this(d, segment, fieldInfos, 1024);
    }

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos, int readBufferSize) throws CorruptIndexException, IOException {
        this(d, segment, fieldInfos, readBufferSize, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos, int readBufferSize, int docStoreOffset, int size2) throws CorruptIndexException, IOException {
        boolean success2 = false;
        try {
            if (d.fileExists(segment + "." + "tvx")) {
                this.tvx = d.openInput(segment + "." + "tvx", readBufferSize);
                this.format = this.checkValidFormat(this.tvx);
                this.tvd = d.openInput(segment + "." + "tvd", readBufferSize);
                int tvdFormat = this.checkValidFormat(this.tvd);
                this.tvf = d.openInput(segment + "." + "tvf", readBufferSize);
                int tvfFormat = this.checkValidFormat(this.tvf);
                if (!$assertionsDisabled && this.format != tvdFormat) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.format != tvfFormat) {
                    throw new AssertionError();
                }
                if (this.format >= 3) {
                    if (!$assertionsDisabled && (this.tvx.length() - 4L) % 16L != 0L) {
                        throw new AssertionError();
                    }
                    this.numTotalDocs = (int)(this.tvx.length() >> 4);
                } else {
                    if (!$assertionsDisabled && (this.tvx.length() - 4L) % 8L != 0L) {
                        throw new AssertionError();
                    }
                    this.numTotalDocs = (int)(this.tvx.length() >> 3);
                }
                if (-1 == docStoreOffset) {
                    this.docStoreOffset = 0;
                    this.size = this.numTotalDocs;
                    if (!$assertionsDisabled && size2 != 0 && this.numTotalDocs != size2) {
                        throw new AssertionError();
                    }
                } else {
                    this.docStoreOffset = docStoreOffset;
                    this.size = size2;
                    if (!$assertionsDisabled && this.numTotalDocs < size2 + docStoreOffset) {
                        throw new AssertionError((Object)("numTotalDocs=" + this.numTotalDocs + " size=" + size2 + " docStoreOffset=" + docStoreOffset));
                    }
                }
            } else {
                this.format = 0;
            }
            this.fieldInfos = fieldInfos;
            success2 = true;
        }
        finally {
            if (!success2) {
                this.close();
            }
        }
    }

    IndexInput getTvdStream() {
        return this.tvd;
    }

    IndexInput getTvfStream() {
        return this.tvf;
    }

    private final void seekTvx(int docNum) throws IOException {
        if (this.format < 3) {
            this.tvx.seek((long)(docNum + this.docStoreOffset) * 8L + 4L);
        } else {
            this.tvx.seek((long)(docNum + this.docStoreOffset) * 16L + 4L);
        }
    }

    boolean canReadRawDocs() {
        return this.format >= 4;
    }

    final void rawDocs(int[] tvdLengths, int[] tvfLengths, int startDocID, int numDocs) throws IOException {
        if (this.tvx == null) {
            Arrays.fill(tvdLengths, 0);
            Arrays.fill(tvfLengths, 0);
            return;
        }
        if (this.format < 3) {
            throw new IllegalStateException("cannot read raw docs with older term vector formats");
        }
        this.seekTvx(startDocID);
        long tvdPosition = this.tvx.readLong();
        this.tvd.seek(tvdPosition);
        long tvfPosition = this.tvx.readLong();
        this.tvf.seek(tvfPosition);
        long lastTvdPosition = tvdPosition;
        long lastTvfPosition = tvfPosition;
        for (int count2 = 0; count2 < numDocs; ++count2) {
            int docID = this.docStoreOffset + startDocID + count2 + 1;
            if (!$assertionsDisabled && docID > this.numTotalDocs) {
                throw new AssertionError();
            }
            if (docID < this.numTotalDocs) {
                tvdPosition = this.tvx.readLong();
                tvfPosition = this.tvx.readLong();
            } else {
                tvdPosition = this.tvd.length();
                tvfPosition = this.tvf.length();
                if (!$assertionsDisabled && count2 != numDocs - 1) {
                    throw new AssertionError();
                }
            }
            tvdLengths[count2] = (int)(tvdPosition - lastTvdPosition);
            tvfLengths[count2] = (int)(tvfPosition - lastTvfPosition);
            lastTvdPosition = tvdPosition;
            lastTvfPosition = tvfPosition;
        }
    }

    private int checkValidFormat(IndexInput in) throws CorruptIndexException, IOException {
        int format2 = in.readInt();
        if (format2 > 4) {
            throw new CorruptIndexException("Incompatible format version: " + format2 + " expected " + 4 + " or less");
        }
        return format2;
    }

    void close() throws IOException {
        IOException keep;
        block12: {
            block11: {
                block10: {
                    keep = null;
                    if (this.tvx != null) {
                        try {
                            this.tvx.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block10;
                            keep = e;
                        }
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block11;
                        keep = e;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException e) {
                    if (keep != null) break block12;
                    keep = e;
                }
            }
        }
        if (keep != null) {
            throw (IOException)keep.fillInStackTrace();
        }
    }

    int size() {
        return this.size;
    }

    public void get(int docNum, String field2, TermVectorMapper mapper) throws IOException {
        if (this.tvx != null) {
            int fieldNumber = this.fieldInfos.fieldNumber(field2);
            this.seekTvx(docNum);
            long tvdPosition = this.tvx.readLong();
            this.tvd.seek(tvdPosition);
            int fieldCount = this.tvd.readVInt();
            int number2 = 0;
            int found = -1;
            for (int i = 0; i < fieldCount; ++i) {
                number2 = this.format >= 2 ? this.tvd.readVInt() : (number2 += this.tvd.readVInt());
                if (number2 != fieldNumber) continue;
                found = i;
            }
            if (found != -1) {
                long position = this.format >= 3 ? this.tvx.readLong() : this.tvd.readVLong();
                for (int i = 1; i <= found; ++i) {
                    position += this.tvd.readVLong();
                }
                mapper.setDocumentNumber(docNum);
                this.readTermVector(field2, position, mapper);
            }
        }
    }

    TermFreqVector get(int docNum, String field2) throws IOException {
        ParallelArrayTermVectorMapper mapper = new ParallelArrayTermVectorMapper();
        this.get(docNum, field2, mapper);
        return mapper.materializeVector();
    }

    private final String[] readFields(int fieldCount) throws IOException {
        int number2 = 0;
        String[] fields = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            number2 = this.format >= 2 ? this.tvd.readVInt() : (number2 += this.tvd.readVInt());
            fields[i] = this.fieldInfos.fieldName(number2);
        }
        return fields;
    }

    private final long[] readTvfPointers(int fieldCount) throws IOException {
        long position = this.format >= 3 ? this.tvx.readLong() : this.tvd.readVLong();
        long[] tvfPointers = new long[fieldCount];
        tvfPointers[0] = position;
        for (int i = 1; i < fieldCount; ++i) {
            tvfPointers[i] = position += this.tvd.readVLong();
        }
        return tvfPointers;
    }

    TermFreqVector[] get(int docNum) throws IOException {
        SegmentTermVector[] result2 = null;
        if (this.tvx != null) {
            this.seekTvx(docNum);
            long tvdPosition = this.tvx.readLong();
            this.tvd.seek(tvdPosition);
            int fieldCount = this.tvd.readVInt();
            if (fieldCount != 0) {
                String[] fields = this.readFields(fieldCount);
                long[] tvfPointers = this.readTvfPointers(fieldCount);
                result2 = this.readTermVectors(docNum, fields, tvfPointers);
            }
        }
        return result2;
    }

    public void get(int docNumber, TermVectorMapper mapper) throws IOException {
        if (this.tvx != null) {
            this.seekTvx(docNumber);
            long tvdPosition = this.tvx.readLong();
            this.tvd.seek(tvdPosition);
            int fieldCount = this.tvd.readVInt();
            if (fieldCount != 0) {
                String[] fields = this.readFields(fieldCount);
                long[] tvfPointers = this.readTvfPointers(fieldCount);
                mapper.setDocumentNumber(docNumber);
                this.readTermVectors(fields, tvfPointers, mapper);
            }
        }
    }

    private SegmentTermVector[] readTermVectors(int docNum, String[] fields, long[] tvfPointers) throws IOException {
        SegmentTermVector[] res = new SegmentTermVector[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ParallelArrayTermVectorMapper mapper = new ParallelArrayTermVectorMapper();
            mapper.setDocumentNumber(docNum);
            this.readTermVector(fields[i], tvfPointers[i], mapper);
            res[i] = (SegmentTermVector)mapper.materializeVector();
        }
        return res;
    }

    private void readTermVectors(String[] fields, long[] tvfPointers, TermVectorMapper mapper) throws IOException {
        for (int i = 0; i < fields.length; ++i) {
            this.readTermVector(fields[i], tvfPointers[i], mapper);
        }
    }

    private void readTermVector(String field2, long tvfPointer, TermVectorMapper mapper) throws IOException {
        byte[] byteBuffer;
        char[] charBuffer;
        boolean preUTF8;
        boolean storeOffsets;
        boolean storePositions;
        this.tvf.seek(tvfPointer);
        int numTerms = this.tvf.readVInt();
        if (numTerms == 0) {
            return;
        }
        if (this.format >= 2) {
            byte bits2 = this.tvf.readByte();
            storePositions = (bits2 & 1) != 0;
            storeOffsets = (bits2 & 2) != 0;
        } else {
            this.tvf.readVInt();
            storePositions = false;
            storeOffsets = false;
        }
        mapper.setExpectations(field2, numTerms, storeOffsets, storePositions);
        int start = 0;
        int deltaLength = 0;
        int totalLength = 0;
        boolean bl = preUTF8 = this.format < 4;
        if (preUTF8) {
            charBuffer = new char[10];
            byteBuffer = null;
        } else {
            charBuffer = null;
            byteBuffer = new byte[20];
        }
        for (int i = 0; i < numTerms; ++i) {
            int j;
            String term;
            start = this.tvf.readVInt();
            deltaLength = this.tvf.readVInt();
            totalLength = start + deltaLength;
            if (preUTF8) {
                if (charBuffer.length < totalLength) {
                    char[] newCharBuffer = new char[(int)(1.5 * (double)totalLength)];
                    System.arraycopy(charBuffer, 0, newCharBuffer, 0, start);
                    charBuffer = newCharBuffer;
                }
                this.tvf.readChars(charBuffer, start, deltaLength);
                term = new String(charBuffer, 0, totalLength);
            } else {
                if (byteBuffer.length < totalLength) {
                    byte[] newByteBuffer = new byte[(int)(1.5 * (double)totalLength)];
                    System.arraycopy(byteBuffer, 0, newByteBuffer, 0, start);
                    byteBuffer = newByteBuffer;
                }
                this.tvf.readBytes(byteBuffer, start, deltaLength);
                term = new String(byteBuffer, 0, totalLength, "UTF-8");
            }
            int freq = this.tvf.readVInt();
            int[] positions = null;
            if (storePositions) {
                if (!mapper.isIgnoringPositions()) {
                    positions = new int[freq];
                    int prevPosition = 0;
                    for (j = 0; j < freq; ++j) {
                        positions[j] = prevPosition + this.tvf.readVInt();
                        prevPosition = positions[j];
                    }
                } else {
                    for (int j2 = 0; j2 < freq; ++j2) {
                        this.tvf.readVInt();
                    }
                }
            }
            TermVectorOffsetInfo[] offsets = null;
            if (storeOffsets) {
                if (!mapper.isIgnoringOffsets()) {
                    offsets = new TermVectorOffsetInfo[freq];
                    int prevOffset = 0;
                    for (int j3 = 0; j3 < freq; ++j3) {
                        int startOffset = prevOffset + this.tvf.readVInt();
                        int endOffset = startOffset + this.tvf.readVInt();
                        offsets[j3] = new TermVectorOffsetInfo(startOffset, endOffset);
                        prevOffset = endOffset;
                    }
                } else {
                    for (j = 0; j < freq; ++j) {
                        this.tvf.readVInt();
                        this.tvf.readVInt();
                    }
                }
            }
            mapper.map(term, freq, offsets, positions);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        TermVectorsReader clone2 = (TermVectorsReader)super.clone();
        if (this.tvx != null && this.tvd != null && this.tvf != null) {
            clone2.tvx = (IndexInput)this.tvx.clone();
            clone2.tvd = (IndexInput)this.tvd.clone();
            clone2.tvf = (IndexInput)this.tvf.clone();
        }
        return clone2;
    }

    static {
        $assertionsDisabled = !TermVectorsReader.class.desiredAssertionStatus();
    }
}

