/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.AllTermDocs;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.CloseableThreadLocal;

public class SegmentReader
extends IndexReader
implements Cloneable {
    protected boolean readOnly;
    private SegmentInfo si;
    private int readBufferSize;
    CloseableThreadLocal fieldsReaderLocal = new FieldsReaderLocal();
    CloseableThreadLocal termVectorsLocal = new CloseableThreadLocal();
    BitVector deletedDocs = null;
    Ref deletedDocsRef = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private int pendingDeleteCount;
    private boolean rollbackHasChanges = false;
    private boolean rollbackDeletedDocsDirty = false;
    private boolean rollbackNormsDirty = false;
    private int rollbackPendingDeleteCount;
    private IndexInput singleNormStream;
    private Ref singleNormRef;
    CoreReaders core;
    Map norms = new HashMap();
    private static Class IMPL;
    private static Class READONLY_IMPL;
    private byte[] ones;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static SegmentReader get(SegmentInfo si) throws CorruptIndexException, IOException {
        return SegmentReader.get(false, si.dir, si, 1024, true, IndexReader.DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static SegmentReader get(boolean readOnly, SegmentInfo si, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return SegmentReader.get(readOnly, si.dir, si, 1024, true, termInfosIndexDivisor);
    }

    static SegmentReader get(SegmentInfo si, int readBufferSize, boolean doOpenStores, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return SegmentReader.get(false, si.dir, si, readBufferSize, doOpenStores, termInfosIndexDivisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SegmentReader get(boolean readOnly, Directory dir2, SegmentInfo si, int readBufferSize, boolean doOpenStores, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        SegmentReader instance;
        try {
            instance = readOnly ? (SegmentReader)READONLY_IMPL.newInstance() : (SegmentReader)IMPL.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        instance.readOnly = readOnly;
        instance.si = si;
        instance.readBufferSize = readBufferSize;
        boolean success2 = false;
        try {
            instance.core = new CoreReaders(instance, dir2, si, readBufferSize, termInfosIndexDivisor);
            if (doOpenStores) {
                instance.core.openDocStores(si);
            }
            instance.loadDeletedDocs();
            instance.openNorms(instance.core.cfsDir, readBufferSize);
            success2 = true;
        }
        finally {
            if (!success2) {
                instance.doClose();
            }
        }
        return instance;
    }

    void openDocStores() throws IOException {
        this.core.openDocStores(this.si);
    }

    private boolean checkDeletedCounts() throws IOException {
        int recomputedCount = this.deletedDocs.getRecomputedCount();
        if (!$assertionsDisabled && this.deletedDocs.count() != recomputedCount) {
            throw new AssertionError((Object)("deleted count=" + this.deletedDocs.count() + " vs recomputed count=" + recomputedCount));
        }
        if (!$assertionsDisabled && this.si.getDelCount() != recomputedCount) {
            throw new AssertionError((Object)("delete count mismatch: info=" + this.si.getDelCount() + " vs BitVector=" + recomputedCount));
        }
        if (!$assertionsDisabled && this.si.getDelCount() > this.maxDoc()) {
            throw new AssertionError((Object)("delete count mismatch: " + recomputedCount + ") exceeds max doc (" + this.maxDoc() + ") for segment " + this.si.name));
        }
        return true;
    }

    private void loadDeletedDocs() throws IOException {
        if (SegmentReader.hasDeletions(this.si)) {
            this.deletedDocs = new BitVector(this.directory(), this.si.getDelFileName());
            this.deletedDocsRef = new Ref();
            if (!$assertionsDisabled && !this.checkDeletedCounts()) {
                throw new AssertionError();
            }
        } else if (!$assertionsDisabled && this.si.getDelCount() != 0) {
            throw new AssertionError();
        }
    }

    protected byte[] cloneNormBytes(byte[] bytes) {
        byte[] cloneBytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, cloneBytes, 0, bytes.length);
        return cloneBytes;
    }

    protected BitVector cloneDeletedDocs(BitVector bv) {
        return (BitVector)bv.clone();
    }

    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public final synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, true, openReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SegmentReader reopenSegment(SegmentInfo si, boolean doClone, boolean openReadOnly) throws CorruptIndexException, IOException {
        SegmentReader clone2;
        boolean deletionsUpToDate = this.si.hasDeletions() == si.hasDeletions() && (!si.hasDeletions() || this.si.getDelFileName().equals(si.getDelFileName()));
        boolean normsUpToDate = true;
        boolean[] fieldNormsChanged = new boolean[this.core.fieldInfos.size()];
        int fieldCount = this.core.fieldInfos.size();
        for (int i = 0; i < fieldCount; ++i) {
            if (this.si.getNormFileName(i).equals(si.getNormFileName(i))) continue;
            normsUpToDate = false;
            fieldNormsChanged[i] = true;
        }
        if (normsUpToDate && deletionsUpToDate && !doClone && openReadOnly && this.readOnly) {
            return this;
        }
        if (!($assertionsDisabled || !doClone || normsUpToDate && deletionsUpToDate)) {
            throw new AssertionError();
        }
        try {
            clone2 = openReadOnly ? (SegmentReader)READONLY_IMPL.newInstance() : (SegmentReader)IMPL.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        boolean success2 = false;
        try {
            this.core.incRef();
            clone2.core = this.core;
            clone2.readOnly = openReadOnly;
            clone2.si = si;
            clone2.readBufferSize = this.readBufferSize;
            if (!openReadOnly && this.hasChanges) {
                clone2.pendingDeleteCount = this.pendingDeleteCount;
                clone2.deletedDocsDirty = this.deletedDocsDirty;
                clone2.normsDirty = this.normsDirty;
                clone2.hasChanges = this.hasChanges;
                this.hasChanges = false;
            }
            if (doClone) {
                if (this.deletedDocs != null) {
                    this.deletedDocsRef.incRef();
                    clone2.deletedDocs = this.deletedDocs;
                    clone2.deletedDocsRef = this.deletedDocsRef;
                }
            } else if (!deletionsUpToDate) {
                if (!$assertionsDisabled && clone2.deletedDocs != null) {
                    throw new AssertionError();
                }
                clone2.loadDeletedDocs();
            } else if (this.deletedDocs != null) {
                this.deletedDocsRef.incRef();
                clone2.deletedDocs = this.deletedDocs;
                clone2.deletedDocsRef = this.deletedDocsRef;
            }
            clone2.setDisableFakeNorms(this.getDisableFakeNorms());
            clone2.norms = new HashMap();
            for (int i = 0; i < fieldNormsChanged.length; ++i) {
                String curField;
                Norm norm;
                if (!doClone && fieldNormsChanged[i] || (norm = (Norm)this.norms.get(curField = this.core.fieldInfos.fieldInfo((int)i).name)) == null) continue;
                clone2.norms.put(curField, norm.clone());
            }
            clone2.openNorms(si.getUseCompoundFile() ? this.core.getCFSReader() : this.directory(), this.readBufferSize);
            success2 = true;
        }
        finally {
            if (!success2) {
                clone2.decRef();
            }
        }
        return clone2;
    }

    protected void doCommit() throws IOException {
        this.doCommit(null);
    }

    protected void doCommit(Map commitUserData) throws IOException {
        if (this.hasChanges) {
            if (this.deletedDocsDirty) {
                this.si.advanceDelGen();
                this.deletedDocs.write(this.directory(), this.si.getDelFileName());
                this.si.setDelCount(this.si.getDelCount() + this.pendingDeleteCount);
                this.pendingDeleteCount = 0;
                if (!$assertionsDisabled && this.deletedDocs.count() != this.si.getDelCount()) {
                    throw new AssertionError((Object)("delete count mismatch during commit: info=" + this.si.getDelCount() + " vs BitVector=" + this.deletedDocs.count()));
                }
            } else if (!$assertionsDisabled && this.pendingDeleteCount != 0) {
                throw new AssertionError();
            }
            if (this.normsDirty) {
                this.si.setNumFields(this.core.fieldInfos.size());
                Iterator it = this.norms.values().iterator();
                while (it.hasNext()) {
                    Norm norm = (Norm)it.next();
                    if (!norm.dirty) continue;
                    norm.reWrite(this.si);
                }
            }
            this.deletedDocsDirty = false;
            this.normsDirty = false;
            this.hasChanges = false;
        }
    }

    FieldsReader getFieldsReader() {
        return (FieldsReader)this.fieldsReaderLocal.get();
    }

    protected void doClose() throws IOException {
        this.termVectorsLocal.close();
        this.fieldsReaderLocal.close();
        if (this.deletedDocs != null) {
            this.deletedDocsRef.decRef();
            this.deletedDocs = null;
        }
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            ((Norm)it.next()).decRef();
        }
        if (this.core != null) {
            this.core.decRef();
        }
    }

    static boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.hasDeletions();
    }

    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.getUseCompoundFile();
    }

    static boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        return si.hasSeparateNorms();
    }

    protected void doDelete(int docNum) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
            this.deletedDocsRef = new Ref();
        }
        if (this.deletedDocsRef.refCount() > 1) {
            Ref oldRef = this.deletedDocsRef;
            this.deletedDocs = this.cloneDeletedDocs(this.deletedDocs);
            this.deletedDocsRef = new Ref();
            oldRef.decRef();
        }
        this.deletedDocsDirty = true;
        if (!this.deletedDocs.getAndSet(docNum)) {
            ++this.pendingDeleteCount;
        }
    }

    protected void doUndeleteAll() {
        this.deletedDocsDirty = false;
        if (this.deletedDocs != null) {
            if (!$assertionsDisabled && this.deletedDocsRef == null) {
                throw new AssertionError();
            }
            this.deletedDocsRef.decRef();
            this.deletedDocs = null;
            this.deletedDocsRef = null;
            this.pendingDeleteCount = 0;
            this.si.clearDelGen();
            this.si.setDelCount(0);
        } else {
            if (!$assertionsDisabled && this.deletedDocsRef != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.pendingDeleteCount != 0) {
                throw new AssertionError();
            }
        }
    }

    List files() throws IOException {
        return new ArrayList(this.si.files());
    }

    public TermEnum terms() {
        this.ensureOpen();
        return this.core.getTermsReader().terms();
    }

    public TermEnum terms(Term t) throws IOException {
        this.ensureOpen();
        return this.core.getTermsReader().terms(t);
    }

    FieldInfos fieldInfos() {
        return this.core.fieldInfos;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.getFieldsReader().doc(n, fieldSelector);
    }

    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public TermDocs termDocs(Term term) throws IOException {
        if (term == null) {
            return new AllTermDocs(this);
        }
        return super.termDocs(term);
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new SegmentTermDocs(this);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new SegmentTermPositions(this);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        TermInfo ti = this.core.getTermsReader().get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public int maxDoc() {
        return this.si.docCount;
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            FieldInfo fi = this.core.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.omitTermFreqAndPositions && fieldOption == IndexReader.FieldOption.OMIT_TERM_FREQ_AND_POSITIONS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePayloads && fieldOption == IndexReader.FieldOption.STORES_PAYLOADS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public synchronized boolean hasNorms(String field2) {
        this.ensureOpen();
        return this.norms.containsKey(field2);
    }

    static byte[] createFakeNorms(int size2) {
        byte[] ones = new byte[size2];
        Arrays.fill(ones, DefaultSimilarity.encodeNorm(1.0f));
        return ones;
    }

    private byte[] fakeNorms() {
        if (!$assertionsDisabled && this.getDisableFakeNorms()) {
            throw new AssertionError();
        }
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    protected synchronized byte[] getNorms(String field2) throws IOException {
        Norm norm = (Norm)this.norms.get(field2);
        if (norm == null) {
            return null;
        }
        return norm.bytes();
    }

    public synchronized byte[] norms(String field2) throws IOException {
        this.ensureOpen();
        byte[] bytes = this.getNorms(field2);
        if (bytes == null && !this.getDisableFakeNorms()) {
            bytes = this.fakeNorms();
        }
        return bytes;
    }

    protected void doSetNorm(int doc, String field2, byte value2) throws IOException {
        Norm norm = (Norm)this.norms.get(field2);
        if (norm == null) {
            return;
        }
        this.normsDirty = true;
        norm.copyOnWrite()[doc] = value2;
    }

    public synchronized void norms(String field2, byte[] bytes, int offset) throws IOException {
        this.ensureOpen();
        Norm norm = (Norm)this.norms.get(field2);
        if (norm == null) {
            Arrays.fill(bytes, offset, bytes.length, DefaultSimilarity.encodeNorm(1.0f));
            return;
        }
        norm.bytes(bytes, offset, this.maxDoc());
    }

    private void openNorms(Directory cfsDir, int readBufferSize) throws IOException {
        long nextNormSeek = SegmentMerger.NORMS_HEADER.length;
        int maxDoc = this.maxDoc();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            long normSeek;
            FieldInfo fi = this.core.fieldInfos.fieldInfo(i);
            if (this.norms.containsKey(fi.name) || !fi.isIndexed || fi.omitNorms) continue;
            Directory d = this.directory();
            String fileName = this.si.getNormFileName(fi.number);
            if (!this.si.hasSeparateNorms(fi.number)) {
                d = cfsDir;
            }
            boolean singleNormFile = fileName.endsWith(".nrm");
            IndexInput normInput = null;
            if (singleNormFile) {
                normSeek = nextNormSeek;
                if (this.singleNormStream == null) {
                    this.singleNormStream = d.openInput(fileName, readBufferSize);
                    this.singleNormRef = new Ref();
                } else {
                    this.singleNormRef.incRef();
                }
                normInput = this.singleNormStream;
            } else {
                normSeek = 0L;
                normInput = d.openInput(fileName);
            }
            this.norms.put(fi.name, new Norm(normInput, fi.number, normSeek));
            nextNormSeek += (long)maxDoc;
        }
    }

    boolean termsIndexLoaded() {
        return this.core.termsIndexIsLoaded();
    }

    void loadTermsIndex(int termsIndexDivisor) throws IOException {
        this.core.loadTermsIndex(this.si, termsIndexDivisor);
    }

    boolean normsClosed() {
        if (this.singleNormStream != null) {
            return false;
        }
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            if (norm.refCount <= 0) continue;
            return false;
        }
        return true;
    }

    boolean normsClosed(String field2) {
        Norm norm = (Norm)this.norms.get(field2);
        return norm.refCount == 0;
    }

    TermVectorsReader getTermVectorsReader() {
        TermVectorsReader tvReader = (TermVectorsReader)this.termVectorsLocal.get();
        if (tvReader == null) {
            TermVectorsReader orig = this.core.getTermVectorsReaderOrig();
            if (orig == null) {
                return null;
            }
            try {
                tvReader = (TermVectorsReader)orig.clone();
            }
            catch (CloneNotSupportedException cnse) {
                return null;
            }
            this.termVectorsLocal.set(tvReader);
        }
        return tvReader;
    }

    TermVectorsReader getTermVectorsReaderOrig() {
        return this.core.getTermVectorsReaderOrig();
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.core.fieldInfos.fieldInfo(field2);
        if (fi == null || !fi.storeTermVector) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber, field2);
    }

    public void getTermFreqVector(int docNumber, String field2, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.core.fieldInfos.fieldInfo(field2);
        if (fi == null || !fi.storeTermVector) {
            return;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, field2, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, mapper);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber);
    }

    public String getSegmentName() {
        return this.core.segment;
    }

    SegmentInfo getSegmentInfo() {
        return this.si;
    }

    void setSegmentInfo(SegmentInfo info) {
        this.si = info;
    }

    void startCommit() {
        this.rollbackHasChanges = this.hasChanges;
        this.rollbackDeletedDocsDirty = this.deletedDocsDirty;
        this.rollbackNormsDirty = this.normsDirty;
        this.rollbackPendingDeleteCount = this.pendingDeleteCount;
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            norm.rollbackDirty = norm.dirty;
        }
    }

    void rollbackCommit() {
        this.hasChanges = this.rollbackHasChanges;
        this.deletedDocsDirty = this.rollbackDeletedDocsDirty;
        this.normsDirty = this.rollbackNormsDirty;
        this.pendingDeleteCount = this.rollbackPendingDeleteCount;
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            norm.dirty = norm.rollbackDirty;
        }
    }

    public Directory directory() {
        return this.core.dir;
    }

    public final Object getFieldCacheKey() {
        return this.core.freqStream;
    }

    public Object getDeletesCacheKey() {
        return this.deletedDocs;
    }

    public long getUniqueTermCount() {
        return this.core.getTermsReader().size();
    }

    static SegmentReader getOnlySegmentReader(Directory dir2) throws IOException {
        return SegmentReader.getOnlySegmentReader(IndexReader.open(dir2));
    }

    static SegmentReader getOnlySegmentReader(IndexReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof DirectoryReader) {
            IndexReader[] subReaders = reader.getSequentialSubReaders();
            if (subReaders.length != 1) {
                throw new IllegalArgumentException(reader + " has " + subReaders.length + " segments instead of exactly one");
            }
            return (SegmentReader)subReaders[0];
        }
        throw new IllegalArgumentException(reader + " is not a SegmentReader or a single-segment DirectoryReader");
    }

    public int getTermInfosIndexDivisor() {
        return this.core.termsIndexDivisor;
    }

    static {
        String name;
        $assertionsDisabled = !SegmentReader.class.desiredAssertionStatus();
        try {
            name = System.getProperty("org.apache.lucene.SegmentReader.class", SegmentReader.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(SegmentReader.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default SegmentReader class: " + e, e);
            }
        }
        try {
            name = System.getProperty("org.apache.lucene.ReadOnlySegmentReader.class", ReadOnlySegmentReader.class.getName());
            READONLY_IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load ReadOnlySegmentReader class: " + e, e);
        }
        catch (SecurityException se) {
            try {
                READONLY_IMPL = Class.forName(ReadOnlySegmentReader.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default ReadOnlySegmentReader class: " + e, e);
            }
        }
    }

    final class Norm
    implements Cloneable {
        private int refCount = 1;
        private Norm origNorm;
        private IndexInput in;
        private long normSeek;
        private Ref bytesRef;
        private byte[] bytes;
        private boolean dirty;
        private int number;
        private boolean rollbackDirty;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Norm(IndexInput in, int number2, long normSeek) {
            this.in = in;
            this.number = number2;
            this.normSeek = normSeek;
        }

        public synchronized void incRef() {
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError();
            }
            ++this.refCount;
        }

        private void closeInput() throws IOException {
            if (this.in != null) {
                if (this.in != SegmentReader.this.singleNormStream) {
                    this.in.close();
                } else if (SegmentReader.this.singleNormRef.decRef() == 0) {
                    SegmentReader.this.singleNormStream.close();
                    SegmentReader.this.singleNormStream = null;
                }
                this.in = null;
            }
        }

        public synchronized void decRef() throws IOException {
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError();
            }
            if (--this.refCount == 0) {
                if (this.origNorm != null) {
                    this.origNorm.decRef();
                    this.origNorm = null;
                } else {
                    this.closeInput();
                }
                if (this.bytes != null) {
                    if (!$assertionsDisabled && this.bytesRef == null) {
                        throw new AssertionError();
                    }
                    this.bytesRef.decRef();
                    this.bytes = null;
                    this.bytesRef = null;
                } else if (!$assertionsDisabled && this.bytesRef != null) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void bytes(byte[] bytesOut, int offset, int len) throws IOException {
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError();
            }
            if (this.bytes != null) {
                if (!$assertionsDisabled && len > SegmentReader.this.maxDoc()) {
                    throw new AssertionError();
                }
                System.arraycopy(this.bytes, 0, bytesOut, offset, len);
            } else if (this.origNorm != null) {
                this.origNorm.bytes(bytesOut, offset, len);
            } else {
                IndexInput indexInput = this.in;
                synchronized (indexInput) {
                    this.in.seek(this.normSeek);
                    this.in.readBytes(bytesOut, offset, len, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized byte[] bytes() throws IOException {
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError();
            }
            if (this.bytes == null) {
                if (!$assertionsDisabled && this.bytesRef != null) {
                    throw new AssertionError();
                }
                if (this.origNorm != null) {
                    this.bytes = this.origNorm.bytes();
                    this.bytesRef = this.origNorm.bytesRef;
                    this.bytesRef.incRef();
                    this.origNorm.decRef();
                    this.origNorm = null;
                } else {
                    int count2 = SegmentReader.this.maxDoc();
                    this.bytes = new byte[count2];
                    if (!$assertionsDisabled && this.in == null) {
                        throw new AssertionError();
                    }
                    IndexInput indexInput = this.in;
                    synchronized (indexInput) {
                        this.in.seek(this.normSeek);
                        this.in.readBytes(this.bytes, 0, count2, false);
                    }
                    this.bytesRef = new Ref();
                    this.closeInput();
                }
            }
            return this.bytes;
        }

        Ref bytesRef() {
            return this.bytesRef;
        }

        public synchronized byte[] copyOnWrite() throws IOException {
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError();
            }
            this.bytes();
            if (!$assertionsDisabled && this.bytes == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.bytesRef == null) {
                throw new AssertionError();
            }
            if (this.bytesRef.refCount() > 1) {
                if (!$assertionsDisabled && this.refCount != 1) {
                    throw new AssertionError();
                }
                Ref oldRef = this.bytesRef;
                this.bytes = SegmentReader.this.cloneNormBytes(this.bytes);
                this.bytesRef = new Ref();
                oldRef.decRef();
            }
            this.dirty = true;
            return this.bytes;
        }

        public synchronized Object clone() {
            Norm clone2;
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError();
            }
            try {
                clone2 = (Norm)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException("unexpected CloneNotSupportedException", cnse);
            }
            clone2.refCount = 1;
            if (this.bytes != null) {
                if (!$assertionsDisabled && this.bytesRef == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.origNorm != null) {
                    throw new AssertionError();
                }
                clone2.bytesRef.incRef();
            } else {
                if (!$assertionsDisabled && this.bytesRef != null) {
                    throw new AssertionError();
                }
                if (this.origNorm == null) {
                    clone2.origNorm = this;
                }
                clone2.origNorm.incRef();
            }
            clone2.in = null;
            return clone2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reWrite(SegmentInfo si) throws IOException {
            if (!$assertionsDisabled && (this.refCount <= 0 || this.origNorm != null && this.origNorm.refCount <= 0)) {
                throw new AssertionError((Object)("refCount=" + this.refCount + " origNorm=" + this.origNorm));
            }
            si.advanceNormGen(this.number);
            IndexOutput out = SegmentReader.this.directory().createOutput(si.getNormFileName(this.number));
            try {
                out.writeBytes(this.bytes, SegmentReader.this.maxDoc());
            }
            finally {
                out.close();
            }
            this.dirty = false;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$SegmentReader == null ? (class$org$apache$lucene$index$SegmentReader = SegmentReader.class$("org.apache.lucene.index.SegmentReader")) : class$org$apache$lucene$index$SegmentReader).desiredAssertionStatus();
        }
    }

    static class Ref {
        private int refCount = 1;
        static final /* synthetic */ boolean $assertionsDisabled;

        Ref() {
        }

        public String toString() {
            return "refcount: " + this.refCount;
        }

        public synchronized int refCount() {
            return this.refCount;
        }

        public synchronized int incRef() {
            if (!$assertionsDisabled && this.refCount <= 0) {
                throw new AssertionError();
            }
            ++this.refCount;
            return this.refCount;
        }

        public synchronized int decRef() {
            if (!$assertionsDisabled && this.refCount <= 0) {
                throw new AssertionError();
            }
            --this.refCount;
            return this.refCount;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$SegmentReader == null ? (class$org$apache$lucene$index$SegmentReader = SegmentReader.class$("org.apache.lucene.index.SegmentReader")) : class$org$apache$lucene$index$SegmentReader).desiredAssertionStatus();
        }
    }

    private class FieldsReaderLocal
    extends CloseableThreadLocal {
        private FieldsReaderLocal() {
        }

        protected Object initialValue() {
            return SegmentReader.this.core.getFieldsReaderOrig().clone();
        }
    }

    static final class CoreReaders {
        private final Ref ref = new Ref();
        final String segment;
        final FieldInfos fieldInfos;
        final IndexInput freqStream;
        final IndexInput proxStream;
        final TermInfosReader tisNoIndex;
        final Directory dir;
        final Directory cfsDir;
        final int readBufferSize;
        final int termsIndexDivisor;
        private final SegmentReader origInstance;
        TermInfosReader tis;
        FieldsReader fieldsReaderOrig;
        TermVectorsReader termVectorsReaderOrig;
        CompoundFileReader cfsReader;
        CompoundFileReader storeCFSReader;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CoreReaders(SegmentReader origInstance, Directory dir2, SegmentInfo si, int readBufferSize, int termsIndexDivisor) throws IOException {
            this.segment = si.name;
            this.readBufferSize = readBufferSize;
            this.dir = dir2;
            boolean success2 = false;
            try {
                Directory dir0 = dir2;
                if (si.getUseCompoundFile()) {
                    this.cfsReader = new CompoundFileReader(dir2, this.segment + "." + "cfs", readBufferSize);
                    dir0 = this.cfsReader;
                }
                this.cfsDir = dir0;
                this.fieldInfos = new FieldInfos(this.cfsDir, this.segment + "." + "fnm");
                this.termsIndexDivisor = termsIndexDivisor;
                TermInfosReader reader = new TermInfosReader(this.cfsDir, this.segment, this.fieldInfos, readBufferSize, termsIndexDivisor);
                if (termsIndexDivisor == -1) {
                    this.tisNoIndex = reader;
                } else {
                    this.tis = reader;
                    this.tisNoIndex = null;
                }
                this.freqStream = this.cfsDir.openInput(this.segment + "." + "frq", readBufferSize);
                this.proxStream = this.fieldInfos.hasProx() ? this.cfsDir.openInput(this.segment + "." + "prx", readBufferSize) : null;
                success2 = true;
            }
            finally {
                if (!success2) {
                    this.decRef();
                }
            }
            this.origInstance = origInstance;
        }

        synchronized TermVectorsReader getTermVectorsReaderOrig() {
            return this.termVectorsReaderOrig;
        }

        synchronized FieldsReader getFieldsReaderOrig() {
            return this.fieldsReaderOrig;
        }

        synchronized void incRef() {
            this.ref.incRef();
        }

        synchronized Directory getCFSReader() {
            return this.cfsReader;
        }

        synchronized TermInfosReader getTermsReader() {
            if (this.tis != null) {
                return this.tis;
            }
            return this.tisNoIndex;
        }

        synchronized boolean termsIndexIsLoaded() {
            return this.tis != null;
        }

        synchronized void loadTermsIndex(SegmentInfo si, int termsIndexDivisor) throws IOException {
            if (this.tis == null) {
                Directory dir0;
                if (si.getUseCompoundFile()) {
                    if (this.cfsReader == null) {
                        this.cfsReader = new CompoundFileReader(this.dir, this.segment + "." + "cfs", this.readBufferSize);
                    }
                    dir0 = this.cfsReader;
                } else {
                    dir0 = this.dir;
                }
                this.tis = new TermInfosReader(dir0, this.segment, this.fieldInfos, this.readBufferSize, termsIndexDivisor);
            }
        }

        synchronized void decRef() throws IOException {
            if (this.ref.decRef() == 0) {
                if (this.tis != null) {
                    this.tis.close();
                    this.tis = null;
                }
                if (this.tisNoIndex != null) {
                    this.tisNoIndex.close();
                }
                if (this.freqStream != null) {
                    this.freqStream.close();
                }
                if (this.proxStream != null) {
                    this.proxStream.close();
                }
                if (this.termVectorsReaderOrig != null) {
                    this.termVectorsReaderOrig.close();
                }
                if (this.fieldsReaderOrig != null) {
                    this.fieldsReaderOrig.close();
                }
                if (this.cfsReader != null) {
                    this.cfsReader.close();
                }
                if (this.storeCFSReader != null) {
                    this.storeCFSReader.close();
                }
                if (this.origInstance != null) {
                    FieldCache.DEFAULT.purge(this.origInstance);
                }
            }
        }

        synchronized void openDocStores(SegmentInfo si) throws IOException {
            if (!$assertionsDisabled && !si.name.equals(this.segment)) {
                throw new AssertionError();
            }
            if (this.fieldsReaderOrig == null) {
                Directory storeDir;
                if (si.getDocStoreOffset() != -1) {
                    if (si.getDocStoreIsCompoundFile()) {
                        if (!$assertionsDisabled && this.storeCFSReader != null) {
                            throw new AssertionError();
                        }
                        this.storeCFSReader = new CompoundFileReader(this.dir, si.getDocStoreSegment() + "." + "cfx", this.readBufferSize);
                        storeDir = this.storeCFSReader;
                        if (!$assertionsDisabled && storeDir == null) {
                            throw new AssertionError();
                        }
                    } else {
                        storeDir = this.dir;
                        if (!$assertionsDisabled && storeDir == null) {
                            throw new AssertionError();
                        }
                    }
                } else if (si.getUseCompoundFile()) {
                    if (this.cfsReader == null) {
                        this.cfsReader = new CompoundFileReader(this.dir, this.segment + "." + "cfs", this.readBufferSize);
                    }
                    storeDir = this.cfsReader;
                    if (!$assertionsDisabled && storeDir == null) {
                        throw new AssertionError();
                    }
                } else {
                    storeDir = this.dir;
                    if (!$assertionsDisabled && storeDir == null) {
                        throw new AssertionError();
                    }
                }
                String storesSegment = si.getDocStoreOffset() != -1 ? si.getDocStoreSegment() : this.segment;
                this.fieldsReaderOrig = new FieldsReader(storeDir, storesSegment, this.fieldInfos, this.readBufferSize, si.getDocStoreOffset(), si.docCount);
                if (si.getDocStoreOffset() == -1 && this.fieldsReaderOrig.size() != si.docCount) {
                    throw new CorruptIndexException("doc counts differ for segment " + this.segment + ": fieldsReader shows " + this.fieldsReaderOrig.size() + " but segmentInfo shows " + si.docCount);
                }
                if (this.fieldInfos.hasVectors()) {
                    this.termVectorsReaderOrig = new TermVectorsReader(storeDir, storesSegment, this.fieldInfos, this.readBufferSize, si.getDocStoreOffset(), si.docCount);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$SegmentReader == null ? (class$org$apache$lucene$index$SegmentReader = SegmentReader.class$("org.apache.lucene.index.SegmentReader")) : class$org$apache$lucene$index$SegmentReader).desiredAssertionStatus();
        }
    }
}

