/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

public class PositionBasedTermVectorMapper
extends TermVectorMapper {
    private Map fieldToTerms;
    private String currentField;
    private Map currentPositions;
    private boolean storeOffsets;

    public PositionBasedTermVectorMapper() {
        super(false, false);
    }

    public PositionBasedTermVectorMapper(boolean ignoringOffsets) {
        super(false, ignoringOffsets);
    }

    public boolean isIgnoringPositions() {
        return false;
    }

    public void map(String term, int frequency, TermVectorOffsetInfo[] offsets, int[] positions) {
        for (int i = 0; i < positions.length; ++i) {
            Integer posVal = new Integer(positions[i]);
            TVPositionInfo pos = (TVPositionInfo)this.currentPositions.get(posVal);
            if (pos == null) {
                pos = new TVPositionInfo(positions[i], this.storeOffsets);
                this.currentPositions.put(posVal, pos);
            }
            pos.addTerm(term, offsets != null ? offsets[i] : null);
        }
    }

    public void setExpectations(String field2, int numTerms, boolean storeOffsets, boolean storePositions) {
        if (!storePositions) {
            throw new RuntimeException("You must store positions in order to use this Mapper");
        }
        if (storeOffsets) {
            // empty if block
        }
        this.fieldToTerms = new HashMap(numTerms);
        this.storeOffsets = storeOffsets;
        this.currentField = field2;
        this.currentPositions = new HashMap();
        this.fieldToTerms.put(this.currentField, this.currentPositions);
    }

    public Map getFieldToTerms() {
        return this.fieldToTerms;
    }

    public static class TVPositionInfo {
        private int position;
        private List terms;
        private List offsets;

        public TVPositionInfo(int position, boolean storeOffsets) {
            this.position = position;
            this.terms = new ArrayList();
            if (storeOffsets) {
                this.offsets = new ArrayList();
            }
        }

        void addTerm(String term, TermVectorOffsetInfo info) {
            this.terms.add(term);
            if (this.offsets != null) {
                this.offsets.add(info);
            }
        }

        public int getPosition() {
            return this.position;
        }

        public List getTerms() {
            return this.terms;
        }

        public List getOffsets() {
            return this.offsets;
        }
    }
}

