/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.FormatPostingsTermsWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.store.Directory;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    final TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    final FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    public FormatPostingsFieldsWriter(SegmentWriteState state, FieldInfos fieldInfos) throws IOException {
        this.dir = state.directory;
        this.segment = state.segmentName;
        this.totalNumDocs = state.numDocs;
        this.fieldInfos = fieldInfos;
        this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, state.termIndexInterval);
        this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
        state.flushedFiles.add(state.segmentFileName("tis"));
        state.flushedFiles.add(state.segmentFileName("tii"));
        this.termsWriter = new FormatPostingsTermsWriter(state, this);
    }

    FormatPostingsTermsConsumer addField(FieldInfo field2) {
        this.termsWriter.setField(field2);
        return this.termsWriter;
    }

    void finish() throws IOException {
        this.termsOut.close();
        this.termsWriter.close();
    }
}

