/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;

final class FieldInfos {
    public static final int FORMAT_PRE = -1;
    public static final int FORMAT_START = -2;
    static final int CURRENT_FORMAT = -2;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 4;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 8;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    private final ArrayList byNumber;
    private final HashMap byName;
    private int format;

    FieldInfos() {
        this.byNumber = new ArrayList();
        this.byName = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory d, String name) throws IOException {
        block8: {
            this.byNumber = new ArrayList();
            this.byName = new HashMap();
            IndexInput input2 = d.openInput(name);
            try {
                try {
                    this.read(input2, name);
                }
                catch (IOException ioe) {
                    if (this.format == -1) {
                        input2.seek(0L);
                        input2.setModifiedUTF8StringsMode();
                        this.byNumber.clear();
                        this.byName.clear();
                        try {
                            this.read(input2, name);
                            break block8;
                        }
                        catch (Throwable t) {
                            throw ioe;
                        }
                    }
                    throw ioe;
                }
            }
            finally {
                input2.close();
            }
        }
    }

    public synchronized Object clone() {
        FieldInfos fis = new FieldInfos();
        int numField = this.byNumber.size();
        for (int i = 0; i < numField; ++i) {
            FieldInfo fi = (FieldInfo)((FieldInfo)this.byNumber.get(i)).clone();
            fis.byNumber.add(fi);
            fis.byName.put(fi.name, fi);
        }
        return fis;
    }

    public synchronized void add(Document doc) {
        List fields = doc.getFields();
        Iterator fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            Fieldable field2 = (Fieldable)fieldIterator.next();
            this.add(field2.name(), field2.isIndexed(), field2.isTermVectorStored(), field2.isStorePositionWithTermVector(), field2.isStoreOffsetWithTermVector(), field2.getOmitNorms(), false, field2.getOmitTf());
        }
    }

    boolean hasProx() {
        int numFields = this.byNumber.size();
        for (int i = 0; i < numFields; ++i) {
            FieldInfo fi = this.fieldInfo(i);
            if (!fi.isIndexed || fi.omitTermFreqAndPositions) continue;
            return true;
        }
        return false;
    }

    public synchronized void addIndexed(Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector);
        }
    }

    public synchronized void add(Collection names, boolean isIndexed) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), isIndexed);
        }
    }

    public synchronized void add(String name, boolean isIndexed) {
        this.add(name, isIndexed, false, false, false, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector) {
        this.add(name, isIndexed, storeTermVector, false, false, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, false, false);
    }

    public synchronized FieldInfo add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, boolean omitTermFreqAndPositions) {
        FieldInfo fi = this.fieldInfo(name);
        if (fi == null) {
            return this.addInternal(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        }
        fi.update(isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        return fi;
    }

    private FieldInfo addInternal(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, boolean omitTermFreqAndPositions) {
        name = StringHelper.intern(name);
        FieldInfo fi = new FieldInfo(name, isIndexed, this.byNumber.size(), storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        this.byNumber.add(fi);
        this.byName.put(name, fi);
        return fi;
    }

    public int fieldNumber(String fieldName) {
        FieldInfo fi = this.fieldInfo(fieldName);
        return fi != null ? fi.number : -1;
    }

    public FieldInfo fieldInfo(String fieldName) {
        return (FieldInfo)this.byName.get(fieldName);
    }

    public String fieldName(int fieldNumber) {
        FieldInfo fi = this.fieldInfo(fieldNumber);
        return fi != null ? fi.name : "";
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        return fieldNumber >= 0 ? (FieldInfo)this.byNumber.get(fieldNumber) : null;
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean hasVectors = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            hasVectors = true;
            break;
        }
        return hasVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory d, String name) throws IOException {
        IndexOutput output2 = d.createOutput(name);
        try {
            this.write(output2);
        }
        finally {
            output2.close();
        }
    }

    public void write(IndexOutput output2) throws IOException {
        output2.writeVInt(-2);
        output2.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fi = this.fieldInfo(i);
            byte bits2 = 0;
            if (fi.isIndexed) {
                bits2 = (byte)(bits2 | 1);
            }
            if (fi.storeTermVector) {
                bits2 = (byte)(bits2 | 2);
            }
            if (fi.storePositionWithTermVector) {
                bits2 = (byte)(bits2 | 4);
            }
            if (fi.storeOffsetWithTermVector) {
                bits2 = (byte)(bits2 | 8);
            }
            if (fi.omitNorms) {
                bits2 = (byte)(bits2 | 0x10);
            }
            if (fi.storePayloads) {
                bits2 = (byte)(bits2 | 0x20);
            }
            if (fi.omitTermFreqAndPositions) {
                bits2 = (byte)(bits2 | 0x40);
            }
            output2.writeString(fi.name);
            output2.writeByte(bits2);
        }
    }

    private void read(IndexInput input2, String fileName) throws IOException {
        int firstInt = input2.readVInt();
        this.format = firstInt < 0 ? firstInt : -1;
        if (this.format != -1 & this.format != -2) {
            throw new CorruptIndexException("unrecognized format " + this.format + " in file \"" + fileName + "\"");
        }
        int size2 = this.format == -1 ? firstInt : input2.readVInt();
        for (int i = 0; i < size2; ++i) {
            String name = StringHelper.intern(input2.readString());
            byte bits2 = input2.readByte();
            boolean isIndexed = (bits2 & 1) != 0;
            boolean storeTermVector = (bits2 & 2) != 0;
            boolean storePositionsWithTermVector = (bits2 & 4) != 0;
            boolean storeOffsetWithTermVector = (bits2 & 8) != 0;
            boolean omitNorms = (bits2 & 0x10) != 0;
            boolean storePayloads = (bits2 & 0x20) != 0;
            boolean omitTermFreqAndPositions = (bits2 & 0x40) != 0;
            this.addInternal(name, isIndexed, storeTermVector, storePositionsWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        }
        if (input2.getFilePointer() != input2.length()) {
            throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input2.getFilePointer() + " vs size " + input2.length());
        }
    }
}

