/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class CheckIndex {
    public static PrintStream out;
    private PrintStream infoStream;
    private Directory dir;
    private static boolean assertsOn;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CheckIndex(Directory dir2) {
        this.dir = dir2;
        this.infoStream = out;
    }

    public void setInfoStream(PrintStream out) {
        this.infoStream = out;
    }

    private void msg(String msg) {
        if (this.infoStream != null) {
            this.infoStream.println(msg);
        }
    }

    public static boolean check(Directory dir2, boolean doFix) throws IOException {
        return CheckIndex.check(dir2, doFix, null);
    }

    public static boolean check(Directory dir2, boolean doFix, List onlySegments) throws IOException {
        CheckIndex checker = new CheckIndex(dir2);
        Status status = checker.checkIndex(onlySegments);
        if (doFix && !status.clean) {
            checker.fixIndex(status);
        }
        return status.clean;
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status checkIndex(List onlySegments) throws IOException {
        int format2;
        String segmentsFileName;
        int numSegments;
        Status result2;
        SegmentInfos sis;
        NumberFormat nf;
        block57: {
            nf = NumberFormat.getInstance();
            sis = new SegmentInfos();
            result2 = new Status();
            result2.dir = this.dir;
            try {
                sis.read(this.dir);
            }
            catch (Throwable t) {
                this.msg("ERROR: could not read any segments file in directory");
                result2.missingSegments = true;
                if (this.infoStream == null) return result2;
                t.printStackTrace(this.infoStream);
                return result2;
            }
            numSegments = sis.size();
            segmentsFileName = sis.getCurrentSegmentFileName();
            IndexInput input2 = null;
            try {
                input2 = this.dir.openInput(segmentsFileName);
            }
            catch (Throwable t) {
                this.msg("ERROR: could not open segments file in directory");
                if (this.infoStream != null) {
                    t.printStackTrace(this.infoStream);
                }
                result2.cantOpenSegments = true;
                return result2;
            }
            format2 = 0;
            try {
                try {
                    format2 = input2.readInt();
                }
                catch (Throwable t) {
                    this.msg("ERROR: could not read segment file version in directory");
                    if (this.infoStream != null) {
                        t.printStackTrace(this.infoStream);
                    }
                    result2.missingSegmentVersion = true;
                    Status status = result2;
                    Object var12_12 = null;
                    if (input2 == null) return status;
                    input2.close();
                    return status;
                }
                Object var12_11 = null;
                if (input2 == null) break block57;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (input2 == null) throw throwable;
                input2.close();
                throw throwable;
            }
            input2.close();
        }
        String sFormat = "";
        boolean skip = false;
        if (format2 == -1) {
            sFormat = "FORMAT [Lucene Pre-2.1]";
        }
        if (format2 == -2) {
            sFormat = "FORMAT_LOCKLESS [Lucene 2.1]";
        } else if (format2 == -3) {
            sFormat = "FORMAT_SINGLE_NORM_FILE [Lucene 2.2]";
        } else if (format2 == -4) {
            sFormat = "FORMAT_SHARED_DOC_STORE [Lucene 2.3]";
        } else if (format2 == -5) {
            sFormat = "FORMAT_CHECKSUM [Lucene 2.4]";
        } else if (format2 == -6) {
            sFormat = "FORMAT_DEL_COUNT [Lucene 2.4]";
        } else if (format2 == -7) {
            sFormat = "FORMAT_HAS_PROX [Lucene 2.4]";
        } else if (format2 == -8) {
            sFormat = "FORMAT_USER_DATA [Lucene 2.9]";
        } else if (format2 == -9) {
            sFormat = "FORMAT_DIAGNOSTICS [Lucene 2.9]";
        } else if (format2 < -9) {
            sFormat = "int=" + format2 + " [newer version of Lucene than this tool]";
            skip = true;
        } else {
            sFormat = format2 + " [Lucene 1.3 or prior]";
        }
        result2.segmentsFileName = segmentsFileName;
        result2.numSegments = numSegments;
        result2.segmentFormat = sFormat;
        result2.userData = sis.getUserData();
        String userDataString = sis.getUserData().size() > 0 ? " userData=" + sis.getUserData() : "";
        this.msg("Segments file=" + segmentsFileName + " numSegments=" + numSegments + " version=" + sFormat + userDataString);
        if (onlySegments != null) {
            result2.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
            }
            Iterator it = onlySegments.iterator();
            while (it.hasNext()) {
                if (this.infoStream == null) continue;
                this.infoStream.print(" " + it.next());
            }
            result2.segmentsChecked.addAll(onlySegments);
            this.msg(":");
        }
        if (skip) {
            this.msg("\nERROR: this index appears to be created by a newer version of Lucene than this tool was compiled on; please re-compile this tool on the matching version of Lucene; exiting");
            result2.toolOutOfDate = true;
            return result2;
        }
        result2.newSegments = (SegmentInfos)sis.clone();
        result2.newSegments.clear();
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info;
            block58: {
                Object var23_32;
                info = sis.info(i);
                if (onlySegments != null && !onlySegments.contains(info.name)) continue;
                Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
                result2.segmentInfos.add(segInfoStat);
                this.msg("  " + (1 + i) + " of " + numSegments + ": name=" + info.name + " docCount=" + info.docCount);
                segInfoStat.name = info.name;
                segInfoStat.docCount = info.docCount;
                int toLoseDocCount = info.docCount;
                IndexReader reader = null;
                try {
                    try {
                        int numDocs;
                        String delFileName;
                        int docStoreOffset;
                        Map diagnostics;
                        this.msg("    compound=" + info.getUseCompoundFile());
                        segInfoStat.compound = info.getUseCompoundFile();
                        this.msg("    hasProx=" + info.getHasProx());
                        segInfoStat.hasProx = info.getHasProx();
                        this.msg("    numFiles=" + info.files().size());
                        segInfoStat.numFiles = info.files().size();
                        this.msg("    size (MB)=" + nf.format((double)info.sizeInBytes() / 1048576.0));
                        segInfoStat.sizeMB = (double)info.sizeInBytes() / 1048576.0;
                        segInfoStat.diagnostics = diagnostics = info.getDiagnostics();
                        if (diagnostics.size() > 0) {
                            this.msg("    diagnostics = " + diagnostics);
                        }
                        if ((docStoreOffset = info.getDocStoreOffset()) != -1) {
                            this.msg("    docStoreOffset=" + docStoreOffset);
                            segInfoStat.docStoreOffset = docStoreOffset;
                            this.msg("    docStoreSegment=" + info.getDocStoreSegment());
                            segInfoStat.docStoreSegment = info.getDocStoreSegment();
                            this.msg("    docStoreIsCompoundFile=" + info.getDocStoreIsCompoundFile());
                            segInfoStat.docStoreCompoundFile = info.getDocStoreIsCompoundFile();
                        }
                        if ((delFileName = info.getDelFileName()) == null) {
                            this.msg("    no deletions");
                            segInfoStat.hasDeletions = false;
                        } else {
                            this.msg("    has deletions [delFileName=" + delFileName + "]");
                            segInfoStat.hasDeletions = true;
                            segInfoStat.deletionsFileName = delFileName;
                        }
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: open reader.........");
                        }
                        reader = SegmentReader.get(info);
                        segInfoStat.openReaderPassed = true;
                        toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
                        if (((SegmentReader)reader).hasDeletions()) {
                            if (((SegmentReader)reader).deletedDocs.count() != info.getDelCount()) {
                                throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs deletedDocs.count()=" + ((SegmentReader)reader).deletedDocs.count());
                            }
                            if (((SegmentReader)reader).deletedDocs.count() > ((SegmentReader)reader).maxDoc()) {
                                throw new RuntimeException("too many deleted docs: maxDoc()=" + ((SegmentReader)reader).maxDoc() + " vs deletedDocs.count()=" + ((SegmentReader)reader).deletedDocs.count());
                            }
                            if (info.docCount - numDocs != info.getDelCount()) {
                                throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                            }
                            segInfoStat.numDeleted = info.docCount - numDocs;
                            this.msg("OK [" + segInfoStat.numDeleted + " deleted docs]");
                        } else {
                            if (info.getDelCount() != 0) {
                                throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                            }
                            this.msg("OK");
                        }
                        if (((SegmentReader)reader).maxDoc() != info.docCount) {
                            throw new RuntimeException("SegmentReader.maxDoc() " + ((SegmentReader)reader).maxDoc() + " != SegmentInfos.docCount " + info.docCount);
                        }
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: fields..............");
                        }
                        Collection fieldNames = ((SegmentReader)reader).getFieldNames(IndexReader.FieldOption.ALL);
                        this.msg("OK [" + fieldNames.size() + " fields]");
                        segInfoStat.numFields = fieldNames.size();
                        segInfoStat.fieldNormStatus = this.testFieldNorms(fieldNames, (SegmentReader)reader);
                        segInfoStat.termIndexStatus = this.testTermIndex(info, (SegmentReader)reader);
                        segInfoStat.storedFieldStatus = this.testStoredFields(info, (SegmentReader)reader, nf);
                        segInfoStat.termVectorStatus = this.testTermVectors(info, (SegmentReader)reader, nf);
                        if (segInfoStat.fieldNormStatus.error != null) {
                            throw new RuntimeException("Field Norm test failed");
                        }
                        if (segInfoStat.termIndexStatus.error != null) {
                            throw new RuntimeException("Term Index test failed");
                        }
                        if (segInfoStat.storedFieldStatus.error != null) {
                            throw new RuntimeException("Stored Field test failed");
                        }
                        if (segInfoStat.termVectorStatus.error != null) {
                            throw new RuntimeException("Term Vector test failed");
                        }
                        this.msg("");
                    }
                    catch (Throwable t) {
                        this.msg("FAILED");
                        String comment2 = "fixIndex() would remove reference to this segment";
                        this.msg("    WARNING: " + comment2 + "; full exception:");
                        if (this.infoStream != null) {
                            t.printStackTrace(this.infoStream);
                        }
                        this.msg("");
                        result2.totLoseDocCount += toLoseDocCount;
                        ++result2.numBadSegments;
                        var23_32 = null;
                        if (reader == null) continue;
                        reader.close();
                        continue;
                    }
                    var23_32 = null;
                    if (reader == null) break block58;
                }
                catch (Throwable throwable) {
                    var23_32 = null;
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
            }
            result2.newSegments.add(info.clone());
        }
        if (0 == result2.numBadSegments) {
            result2.clean = true;
            this.msg("No problems were detected with this index.\n");
            return result2;
        }
        this.msg("WARNING: " + result2.numBadSegments + " broken segments (containing " + result2.totLoseDocCount + " documents) detected");
        return result2;
    }

    private Status.FieldNormStatus testFieldNorms(Collection fieldNames, SegmentReader reader) {
        Status.FieldNormStatus status;
        block4: {
            status = new Status.FieldNormStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: field norms.........");
                }
                Iterator it = fieldNames.iterator();
                byte[] b = new byte[reader.maxDoc()];
                while (it.hasNext()) {
                    String fieldName = (String)it.next();
                    reader.norms(fieldName, b, 0);
                    ++status.totFields;
                }
                this.msg("OK [" + status.totFields + " fields]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block4;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private Status.TermIndexStatus testTermIndex(SegmentInfo info, SegmentReader reader) {
        Status.TermIndexStatus status;
        block13: {
            status = new Status.TermIndexStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: terms, freq, prox...");
                }
                TermEnum termEnum = reader.terms();
                TermPositions termPositions = reader.termPositions();
                MySegmentTermDocs myTermDocs = new MySegmentTermDocs(reader);
                int maxDoc = reader.maxDoc();
                while (termEnum.next()) {
                    int delCount;
                    ++status.termCount;
                    Term term = termEnum.term();
                    int docFreq = termEnum.docFreq();
                    termPositions.seek(term);
                    int lastDoc = -1;
                    int freq0 = 0;
                    status.totFreq += (long)docFreq;
                    while (termPositions.next()) {
                        ++freq0;
                        int doc = termPositions.doc();
                        int freq = termPositions.freq();
                        if (doc <= lastDoc) {
                            throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                        }
                        if (doc >= maxDoc) {
                            throw new RuntimeException("term " + term + ": doc " + doc + " >= maxDoc " + maxDoc);
                        }
                        lastDoc = doc;
                        if (freq <= 0) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " is out of bounds");
                        }
                        int lastPos = -1;
                        status.totPos += (long)freq;
                        for (int j = 0; j < freq; ++j) {
                            int pos = termPositions.nextPosition();
                            if (pos < -1) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " is out of bounds");
                            }
                            if (pos >= lastPos) continue;
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " < lastPos " + lastPos);
                        }
                    }
                    if (reader.hasDeletions()) {
                        myTermDocs.seek(term);
                        while (myTermDocs.next()) {
                        }
                        delCount = myTermDocs.delCount;
                    } else {
                        delCount = 0;
                    }
                    if (freq0 + delCount == docFreq) continue;
                    throw new RuntimeException("term " + term + " docFreq=" + docFreq + " != num docs seen " + freq0 + " + num docs deleted " + delCount);
                }
                this.msg("OK [" + status.termCount + " terms; " + status.totFreq + " terms/docs pairs; " + status.totPos + " tokens]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block13;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private Status.StoredFieldStatus testStoredFields(SegmentInfo info, SegmentReader reader, NumberFormat format2) {
        Status.StoredFieldStatus status;
        block5: {
            status = new Status.StoredFieldStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: stored fields.......");
                }
                for (int j = 0; j < info.docCount; ++j) {
                    if (reader.isDeleted(j)) continue;
                    ++status.docCount;
                    Document doc = reader.document(j);
                    status.totFields += (long)doc.getFields().size();
                }
                if (status.docCount != reader.numDocs()) {
                    throw new RuntimeException("docCount=" + status.docCount + " but saw " + status.docCount + " undeleted docs");
                }
                this.msg("OK [" + status.totFields + " total field count; avg " + format2.format((float)status.totFields / (float)status.docCount) + " fields per doc]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block5;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private Status.TermVectorStatus testTermVectors(SegmentInfo info, SegmentReader reader, NumberFormat format2) {
        Status.TermVectorStatus status;
        block4: {
            status = new Status.TermVectorStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: term vectors........");
                }
                for (int j = 0; j < info.docCount; ++j) {
                    if (reader.isDeleted(j)) continue;
                    ++status.docCount;
                    TermFreqVector[] tfv = reader.getTermFreqVectors(j);
                    if (tfv == null) continue;
                    status.totVectors += (long)tfv.length;
                }
                this.msg("OK [" + status.totVectors + " total vector count; avg " + format2.format((float)status.totVectors / (float)status.docCount) + " term/freq vector fields per doc]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block4;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    public void fixIndex(Status result2) throws IOException {
        if (result2.partial) {
            throw new IllegalArgumentException("can only fix an index that was fully checked (this status checked a subset of segments)");
        }
        result2.newSegments.commit(result2.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    private static boolean assertsOn() {
        if (!$assertionsDisabled && !CheckIndex.testAsserts()) {
            throw new AssertionError();
        }
        return assertsOn;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        boolean doFix = false;
        ArrayList<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-fix")) {
                doFix = true;
                ++i;
                continue;
            }
            if (args[i].equals("-segment")) {
                if (i == args.length - 1) {
                    System.out.println("ERROR: missing name for -segment option");
                    System.exit(1);
                }
                onlySegments.add(args[i + 1]);
                i += 2;
                continue;
            }
            if (indexPath != null) {
                System.out.println("ERROR: unexpected extra argument '" + args[i] + "'");
                System.exit(1);
            }
            indexPath = args[i];
            ++i;
        }
        if (indexPath == null) {
            System.out.println("\nERROR: index path not specified");
            System.out.println("\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-fix] [-segment X] [-segment Y]\n\n  -fix: actually write a new segments_N file, removing any problematic segments\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -fix option\n\n**WARNING**: -fix should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -fix, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -fix were\nspecified.  With -fix, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n");
            System.exit(1);
        }
        if (!CheckIndex.assertsOn()) {
            System.out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled");
        }
        if (onlySegments.size() == 0) {
            onlySegments = null;
        } else if (doFix) {
            System.out.println("ERROR: cannot specify both -fix and -segment");
            System.exit(1);
        }
        System.out.println("\nOpening index @ " + indexPath + "\n");
        FSDirectory dir2 = null;
        try {
            dir2 = FSDirectory.open(new File(indexPath));
        }
        catch (Throwable t) {
            System.out.println("ERROR: could not open directory \"" + indexPath + "\"; exiting");
            t.printStackTrace(System.out);
            System.exit(1);
        }
        CheckIndex checker = new CheckIndex(dir2);
        checker.setInfoStream(System.out);
        Status result2 = checker.checkIndex(onlySegments);
        if (result2.missingSegments) {
            System.exit(1);
        }
        if (!result2.clean) {
            if (!doFix) {
                System.out.println("WARNING: would write new segments file, and " + result2.totLoseDocCount + " documents would be lost, if -fix were specified\n");
            } else {
                System.out.println("WARNING: " + result2.totLoseDocCount + " documents will be lost\n");
                System.out.println("NOTE: will write new segments file in 5 seconds; this will remove " + result2.totLoseDocCount + " docs from the index. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                for (int s = 0; s < 5; ++s) {
                    Thread.sleep(1000L);
                    System.out.println("  " + (5 - s) + "...");
                }
                System.out.println("Writing...");
                checker.fixIndex(result2);
                System.out.println("OK");
                System.out.println("Wrote new segments file \"" + result2.newSegments.getCurrentSegmentFileName() + "\"");
            }
        }
        System.out.println("");
        int exitCode = result2 != null && result2.clean ? 0 : 1;
        System.exit(exitCode);
    }

    static {
        $assertionsDisabled = !CheckIndex.class.desiredAssertionStatus();
        out = null;
    }

    private static class MySegmentTermDocs
    extends SegmentTermDocs {
        int delCount;

        MySegmentTermDocs(SegmentReader p) {
            super(p);
        }

        public void seek(Term term) throws IOException {
            super.seek(term);
            this.delCount = 0;
        }

        protected void skippingDoc() throws IOException {
            ++this.delCount;
        }
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public boolean cantOpenSegments;
        public boolean missingSegmentVersion;
        public String segmentsFileName;
        public int numSegments;
        public String segmentFormat;
        public List segmentsChecked = new ArrayList();
        public boolean toolOutOfDate;
        public List segmentInfos = new ArrayList();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;
        public Map userData;

        public static final class TermVectorStatus {
            public int docCount = 0;
            public long totVectors = 0L;
            public Throwable error = null;
        }

        public static final class StoredFieldStatus {
            public int docCount = 0;
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static final class TermIndexStatus {
            public long termCount = 0L;
            public long totFreq = 0L;
            public long totPos = 0L;
            public Throwable error = null;
        }

        public static final class FieldNormStatus {
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static class SegmentInfoStatus {
            public String name;
            public int docCount;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public int docStoreOffset = -1;
            public String docStoreSegment;
            public boolean docStoreCompoundFile;
            public boolean hasDeletions;
            public String deletionsFileName;
            public int numDeleted;
            public boolean openReaderPassed;
            int numFields;
            public boolean hasProx;
            public Map diagnostics;
            public FieldNormStatus fieldNormStatus;
            public TermIndexStatus termIndexStatus;
            public StoredFieldStatus storedFieldStatus;
            public TermVectorStatus termVectorStatus;
        }
    }
}

