/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.index.MergeDocIDRemapper;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfos;

class BufferedDeletes {
    int numTerms;
    Map terms;
    Map queries = new HashMap();
    List docIDs = new ArrayList();
    long bytesUsed;
    private final boolean doTermSort;

    public BufferedDeletes(boolean doTermSort) {
        this.doTermSort = doTermSort;
        this.terms = doTermSort ? new TreeMap() : new HashMap();
    }

    int size() {
        return this.numTerms + this.queries.size() + this.docIDs.size();
    }

    void update(BufferedDeletes in) {
        this.numTerms += in.numTerms;
        this.bytesUsed += in.bytesUsed;
        this.terms.putAll(in.terms);
        this.queries.putAll(in.queries);
        this.docIDs.addAll(in.docIDs);
        in.clear();
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numTerms = 0;
        this.bytesUsed = 0L;
    }

    void addBytesUsed(long b) {
        this.bytesUsed += b;
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0;
    }

    synchronized void remap(MergeDocIDRemapper mapper, SegmentInfos infos, int[][] docMaps, int[] delCounts, MergePolicy.OneMerge merge, int mergeDocCount) {
        HashMap newDeleteQueries;
        ArrayList<Integer> newDeleteDocIDs;
        Object num2;
        AbstractMap newDeleteTerms;
        if (this.terms.size() > 0) {
            newDeleteTerms = this.doTermSort ? new TreeMap() : new HashMap();
            Iterator iter2 = this.terms.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                num2 = (Num)entry.getValue();
                newDeleteTerms.put(entry.getKey(), new Num(mapper.remap(((Num)num2).getNum())));
            }
        } else {
            newDeleteTerms = null;
        }
        if (this.docIDs.size() > 0) {
            newDeleteDocIDs = new ArrayList<Integer>(this.docIDs.size());
            Iterator iter3 = this.docIDs.iterator();
            while (iter3.hasNext()) {
                num2 = (Integer)iter3.next();
                newDeleteDocIDs.add(new Integer(mapper.remap((Integer)num2)));
            }
        } else {
            newDeleteDocIDs = null;
        }
        if (this.queries.size() > 0) {
            newDeleteQueries = new HashMap(this.queries.size());
            Iterator iter4 = this.queries.entrySet().iterator();
            while (iter4.hasNext()) {
                Map.Entry entry = iter4.next();
                Integer num3 = (Integer)entry.getValue();
                newDeleteQueries.put(entry.getKey(), new Integer(mapper.remap(num3)));
            }
        } else {
            newDeleteQueries = null;
        }
        if (newDeleteTerms != null) {
            this.terms = newDeleteTerms;
        }
        if (newDeleteDocIDs != null) {
            this.docIDs = newDeleteDocIDs;
        }
        if (newDeleteQueries != null) {
            this.queries = newDeleteQueries;
        }
    }

    static final class Num {
        private int num;

        Num(int num2) {
            this.num = num2;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num2) {
            if (num2 > this.num) {
                this.num = num2;
            }
        }
    }
}

