/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;

public final class NumericField
extends AbstractField {
    private final NumericTokenStream tokenStream;

    public NumericField(String name) {
        this(name, 4, Field.Store.NO, true);
    }

    public NumericField(String name, Field.Store store, boolean index) {
        this(name, 4, store, index);
    }

    public NumericField(String name, int precisionStep) {
        this(name, precisionStep, Field.Store.NO, true);
    }

    public NumericField(String name, int precisionStep, Field.Store store, boolean index) {
        super(name, store, index ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NO, Field.TermVector.NO);
        this.setOmitTermFreqAndPositions(true);
        this.tokenStream = new NumericTokenStream(precisionStep);
    }

    public TokenStream tokenStreamValue() {
        return this.isIndexed() ? this.tokenStream : null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public byte[] getBinaryValue(byte[] result2) {
        return null;
    }

    public Reader readerValue() {
        return null;
    }

    public String stringValue() {
        return this.fieldsData == null ? null : this.fieldsData.toString();
    }

    public Number getNumericValue() {
        return (Number)this.fieldsData;
    }

    public NumericField setLongValue(long value2) {
        this.tokenStream.setLongValue(value2);
        this.fieldsData = new Long(value2);
        return this;
    }

    public NumericField setIntValue(int value2) {
        this.tokenStream.setIntValue(value2);
        this.fieldsData = new Integer(value2);
        return this;
    }

    public NumericField setDoubleValue(double value2) {
        this.tokenStream.setDoubleValue(value2);
        this.fieldsData = new Double(value2);
        return this;
    }

    public NumericField setFloatValue(float value2) {
        this.tokenStream.setFloatValue(value2);
        this.fieldsData = new Float(value2);
        return this;
    }
}

