/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public final class Document
implements Serializable {
    List fields = new ArrayList();
    private float boost = 1.0f;
    private static final Field[] NO_FIELDS = new Field[0];
    private static final Fieldable[] NO_FIELDABLES = new Fieldable[0];
    private static final String[] NO_STRINGS = new String[0];
    private static final byte[][] NO_BYTES = new byte[0][];

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Fieldable field2) {
        this.fields.add(field2);
    }

    public final void removeField(String name) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Fieldable field2 = (Fieldable)it.next();
            if (!field2.name().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(String name) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Fieldable field2 = (Fieldable)it.next();
            if (!field2.name().equals(name)) continue;
            it.remove();
        }
    }

    public final Field getField(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field2 = (Field)this.fields.get(i);
            if (!field2.name().equals(name)) continue;
            return field2;
        }
        return null;
    }

    public Fieldable getFieldable(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            if (!field2.name().equals(name)) continue;
            return field2;
        }
        return null;
    }

    public final String get(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            if (!field2.name().equals(name) || field2.isBinary()) continue;
            return field2.stringValue();
        }
        return null;
    }

    public final Enumeration fields() {
        return new Enumeration(){
            final Iterator iter;
            {
                this.iter = Document.this.fields.iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public final List getFields() {
        return this.fields;
    }

    public final Field[] getFields(String name) {
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field2 = (Field)this.fields.get(i);
            if (!field2.name().equals(name)) continue;
            result2.add(field2);
        }
        if (result2.size() == 0) {
            return NO_FIELDS;
        }
        return result2.toArray(new Field[result2.size()]);
    }

    public Fieldable[] getFieldables(String name) {
        ArrayList<Fieldable> result2 = new ArrayList<Fieldable>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            if (!field2.name().equals(name)) continue;
            result2.add(field2);
        }
        if (result2.size() == 0) {
            return NO_FIELDABLES;
        }
        return result2.toArray(new Fieldable[result2.size()]);
    }

    public final String[] getValues(String name) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            if (!field2.name().equals(name) || field2.isBinary()) continue;
            result2.add(field2.stringValue());
        }
        if (result2.size() == 0) {
            return NO_STRINGS;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public final byte[][] getBinaryValues(String name) {
        ArrayList<byte[]> result2 = new ArrayList<byte[]>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            if (!field2.name().equals(name) || !field2.isBinary()) continue;
            result2.add(field2.binaryValue());
        }
        if (result2.size() == 0) {
            return NO_BYTES;
        }
        return (byte[][])result2.toArray((T[])new byte[result2.size()][]);
    }

    public final byte[] getBinaryValue(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            if (!field2.name().equals(name) || !field2.isBinary()) continue;
            return field2.binaryValue();
        }
        return null;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document<");
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable field2 = (Fieldable)this.fields.get(i);
            buffer.append(field2.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

