/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.util.StringHelper;

public abstract class AbstractField
implements Fieldable {
    protected String name = "body";
    protected boolean storeTermVector = false;
    protected boolean storeOffsetWithTermVector = false;
    protected boolean storePositionWithTermVector = false;
    protected boolean omitNorms = false;
    protected boolean isStored = false;
    protected boolean isIndexed = true;
    protected boolean isTokenized = true;
    protected boolean isBinary = false;
    protected boolean isCompressed = false;
    protected boolean lazy = false;
    protected boolean omitTermFreqAndPositions = false;
    protected float boost = 1.0f;
    protected Object fieldsData = null;
    protected TokenStream tokenStream;
    protected int binaryLength;
    protected int binaryOffset;

    protected AbstractField() {
    }

    protected AbstractField(String name, Field.Store store, Field.Index index, Field.TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = StringHelper.intern(name);
        if (store == Field.Store.YES) {
            this.isStored = true;
            this.isCompressed = false;
        } else if (store == Field.Store.COMPRESS) {
            this.isStored = true;
            this.isCompressed = true;
        } else if (store == Field.Store.NO) {
            this.isStored = false;
            this.isCompressed = false;
        } else {
            throw new IllegalArgumentException("unknown store parameter " + store);
        }
        if (index == Field.Index.NO) {
            this.isIndexed = false;
            this.isTokenized = false;
        } else if (index == Field.Index.ANALYZED) {
            this.isIndexed = true;
            this.isTokenized = true;
        } else if (index == Field.Index.NOT_ANALYZED) {
            this.isIndexed = true;
            this.isTokenized = false;
        } else if (index == Field.Index.NOT_ANALYZED_NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = false;
            this.omitNorms = true;
        } else if (index == Field.Index.ANALYZED_NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = true;
            this.omitNorms = true;
        } else {
            throw new IllegalArgumentException("unknown index parameter " + index);
        }
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public String name() {
        return this.name;
    }

    protected void setStoreTermVector(Field.TermVector termVector) {
        if (termVector == Field.TermVector.NO) {
            this.storeTermVector = false;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == Field.TermVector.YES) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == Field.TermVector.WITH_POSITIONS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = true;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == Field.TermVector.WITH_OFFSETS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = true;
        } else if (termVector == Field.TermVector.WITH_POSITIONS_OFFSETS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = true;
            this.storeOffsetWithTermVector = true;
        } else {
            throw new IllegalArgumentException("unknown termVector parameter " + termVector);
        }
    }

    public final boolean isStored() {
        return this.isStored;
    }

    public final boolean isIndexed() {
        return this.isIndexed;
    }

    public final boolean isTokenized() {
        return this.isTokenized;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final boolean isTermVectorStored() {
        return this.storeTermVector;
    }

    public boolean isStoreOffsetWithTermVector() {
        return this.storeOffsetWithTermVector;
    }

    public boolean isStorePositionWithTermVector() {
        return this.storePositionWithTermVector;
    }

    public final boolean isBinary() {
        return this.isBinary;
    }

    public byte[] getBinaryValue() {
        return this.getBinaryValue(null);
    }

    public byte[] getBinaryValue(byte[] result2) {
        if (this.isBinary || this.fieldsData instanceof byte[]) {
            return (byte[])this.fieldsData;
        }
        return null;
    }

    public int getBinaryLength() {
        if (this.isBinary) {
            if (!this.isCompressed) {
                return this.binaryLength;
            }
            return ((byte[])this.fieldsData).length;
        }
        if (this.fieldsData instanceof byte[]) {
            return ((byte[])this.fieldsData).length;
        }
        return 0;
    }

    public int getBinaryOffset() {
        return this.binaryOffset;
    }

    public boolean getOmitNorms() {
        return this.omitNorms;
    }

    public boolean getOmitTf() {
        return this.omitTermFreqAndPositions;
    }

    public boolean getOmitTermFreqAndPositions() {
        return this.omitTermFreqAndPositions;
    }

    public void setOmitNorms(boolean omitNorms) {
        this.omitNorms = omitNorms;
    }

    public void setOmitTf(boolean omitTermFreqAndPositions) {
        this.omitTermFreqAndPositions = omitTermFreqAndPositions;
    }

    public void setOmitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
        this.omitTermFreqAndPositions = omitTermFreqAndPositions;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public final String toString() {
        StringBuffer result2 = new StringBuffer();
        if (this.isStored) {
            result2.append("stored");
            if (this.isCompressed) {
                result2.append("/compressed");
            } else {
                result2.append("/uncompressed");
            }
        }
        if (this.isIndexed) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("indexed");
        }
        if (this.isTokenized) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("tokenized");
        }
        if (this.storeTermVector) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("termVector");
        }
        if (this.storeOffsetWithTermVector) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("termVectorOffsets");
        }
        if (this.storePositionWithTermVector) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("termVectorPosition");
        }
        if (this.isBinary) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("binary");
        }
        if (this.omitNorms) {
            result2.append(",omitNorms");
        }
        if (this.omitTermFreqAndPositions) {
            result2.append(",omitTermFreqAndPositions");
        }
        if (this.lazy) {
            result2.append(",lazy");
        }
        result2.append('<');
        result2.append(this.name);
        result2.append(':');
        if (this.fieldsData != null && !this.lazy) {
            result2.append(this.fieldsData);
        }
        result2.append('>');
        return result2.toString();
    }
}

