/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class LengthFilter
extends TokenFilter {
    final int min;
    final int max;
    private TermAttribute termAtt;

    public LengthFilter(TokenStream in, int min2, int max2) {
        super(in);
        this.min = min2;
        this.max = max2;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            int len = this.termAtt.termLength();
            if (len < this.min || len > this.max) continue;
            return true;
        }
        return false;
    }
}

