/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public class KeywordTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private boolean done;
    private int finalOffset;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    public KeywordTokenizer(Reader input2) {
        this(input2, 256);
    }

    public KeywordTokenizer(Reader input2, int bufferSize) {
        super(input2);
        this.init(bufferSize);
    }

    public KeywordTokenizer(AttributeSource source, Reader input2, int bufferSize) {
        super(source, input2);
        this.init(bufferSize);
    }

    public KeywordTokenizer(AttributeSource.AttributeFactory factory, Reader input2, int bufferSize) {
        super(factory, input2);
        this.init(bufferSize);
    }

    private void init(int bufferSize) {
        this.done = false;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.termAtt.resizeTermBuffer(bufferSize);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.done) {
            int length;
            this.clearAttributes();
            this.done = true;
            int upto = 0;
            char[] buffer = this.termAtt.termBuffer();
            while ((length = this.input.read(buffer, upto, buffer.length - upto)) != -1) {
                if ((upto += length) != buffer.length) continue;
                buffer = this.termAtt.resizeTermBuffer(1 + buffer.length);
            }
            this.termAtt.setTermLength(upto);
            this.finalOffset = this.correctOffset(upto);
            this.offsetAtt.setOffset(this.correctOffset(0), this.finalOffset);
            return true;
        }
        return false;
    }

    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset(Reader input2) throws IOException {
        super.reset(input2);
        this.done = false;
    }
}

