/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.NumberUtils;

public class BooleanUtils {
    public static Boolean negate(Boolean bool2) {
        if (bool2 == null) {
            return null;
        }
        return bool2 != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bool2) {
        if (bool2 == null) {
            return false;
        }
        return bool2 != false;
    }

    public static boolean isNotTrue(Boolean bool2) {
        return !BooleanUtils.isTrue(bool2);
    }

    public static boolean isFalse(Boolean bool2) {
        if (bool2 == null) {
            return false;
        }
        return bool2 == false;
    }

    public static boolean isNotFalse(Boolean bool2) {
        return !BooleanUtils.isFalse(bool2);
    }

    public static Boolean toBooleanObject(boolean bool2) {
        return bool2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean toBoolean(Boolean bool2) {
        if (bool2 == null) {
            return false;
        }
        return bool2 != false;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bool2, boolean valueIfNull) {
        if (bool2 == null) {
            return valueIfNull;
        }
        return bool2 != false;
    }

    public static boolean toBoolean(int value2) {
        return value2 != 0;
    }

    public static Boolean toBooleanObject(int value2) {
        return value2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Boolean toBooleanObject(Integer value2) {
        if (value2 == null) {
            return null;
        }
        return value2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean toBoolean(int value2, int trueValue, int falseValue) {
        if (value2 == trueValue) {
            return true;
        }
        if (value2 == falseValue) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(Integer value2, Integer trueValue, Integer falseValue) {
        if (value2 == null) {
            if (trueValue == null) {
                return true;
            }
            if (falseValue == null) {
                return false;
            }
        } else {
            if (value2.equals(trueValue)) {
                return true;
            }
            if (value2.equals(falseValue)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static Boolean toBooleanObject(int value2, int trueValue, int falseValue, int nullValue) {
        if (value2 == trueValue) {
            return Boolean.TRUE;
        }
        if (value2 == falseValue) {
            return Boolean.FALSE;
        }
        if (value2 == nullValue) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer value2, Integer trueValue, Integer falseValue, Integer nullValue) {
        if (value2 == null) {
            if (trueValue == null) {
                return Boolean.TRUE;
            }
            if (falseValue == null) {
                return Boolean.FALSE;
            }
            if (nullValue == null) {
                return null;
            }
        } else {
            if (value2.equals(trueValue)) {
                return Boolean.TRUE;
            }
            if (value2.equals(falseValue)) {
                return Boolean.FALSE;
            }
            if (value2.equals(nullValue)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static int toInteger(boolean bool2) {
        return bool2 ? 1 : 0;
    }

    public static Integer toIntegerObject(boolean bool2) {
        return bool2 ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static Integer toIntegerObject(Boolean bool2) {
        if (bool2 == null) {
            return null;
        }
        return bool2 != false ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static int toInteger(boolean bool2, int trueValue, int falseValue) {
        return bool2 ? trueValue : falseValue;
    }

    public static int toInteger(Boolean bool2, int trueValue, int falseValue, int nullValue) {
        if (bool2 == null) {
            return nullValue;
        }
        return bool2 != false ? trueValue : falseValue;
    }

    public static Integer toIntegerObject(boolean bool2, Integer trueValue, Integer falseValue) {
        return bool2 ? trueValue : falseValue;
    }

    public static Integer toIntegerObject(Boolean bool2, Integer trueValue, Integer falseValue, Integer nullValue) {
        if (bool2 == null) {
            return nullValue;
        }
        return bool2 != false ? trueValue : falseValue;
    }

    public static Boolean toBooleanObject(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        if ("on".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("off".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        if ("yes".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("no".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean toBooleanObject(String str, String trueString, String falseString, String nullString) {
        if (str == null) {
            if (trueString == null) {
                return Boolean.TRUE;
            }
            if (falseString == null) {
                return Boolean.FALSE;
            }
            if (nullString == null) {
                return null;
            }
        } else {
            if (str.equals(trueString)) {
                return Boolean.TRUE;
            }
            if (str.equals(falseString)) {
                return Boolean.FALSE;
            }
            if (str.equals(nullString)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The String did not match any specified value");
    }

    public static boolean toBoolean(String str) {
        if (str == "true") {
            return true;
        }
        if (str == null) {
            return false;
        }
        switch (str.length()) {
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                return !(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N');
            }
            case 3: {
                char ch = str.charAt(0);
                if (ch == 'y') {
                    return !(str.charAt(1) != 'e' && str.charAt(1) != 'E' || str.charAt(2) != 's' && str.charAt(2) != 'S');
                }
                if (ch == 'Y') {
                    return !(str.charAt(1) != 'E' && str.charAt(1) != 'e' || str.charAt(2) != 'S' && str.charAt(2) != 's');
                }
                return false;
            }
            case 4: {
                char ch = str.charAt(0);
                if (ch == 't') {
                    return !(str.charAt(1) != 'r' && str.charAt(1) != 'R' || str.charAt(2) != 'u' && str.charAt(2) != 'U' || str.charAt(3) != 'e' && str.charAt(3) != 'E');
                }
                if (ch != 'T') break;
                return !(str.charAt(1) != 'R' && str.charAt(1) != 'r' || str.charAt(2) != 'U' && str.charAt(2) != 'u' || str.charAt(3) != 'E' && str.charAt(3) != 'e');
            }
        }
        return false;
    }

    public static boolean toBoolean(String str, String trueString, String falseString) {
        if (str == null) {
            if (trueString == null) {
                return true;
            }
            if (falseString == null) {
                return false;
            }
        } else {
            if (str.equals(trueString)) {
                return true;
            }
            if (str.equals(falseString)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    public static String toStringTrueFalse(Boolean bool2) {
        return BooleanUtils.toString(bool2, "true", "false", null);
    }

    public static String toStringOnOff(Boolean bool2) {
        return BooleanUtils.toString(bool2, "on", "off", null);
    }

    public static String toStringYesNo(Boolean bool2) {
        return BooleanUtils.toString(bool2, "yes", "no", null);
    }

    public static String toString(Boolean bool2, String trueString, String falseString, String nullString) {
        if (bool2 == null) {
            return nullString;
        }
        return bool2 != false ? trueString : falseString;
    }

    public static String toStringTrueFalse(boolean bool2) {
        return BooleanUtils.toString(bool2, "true", "false");
    }

    public static String toStringOnOff(boolean bool2) {
        return BooleanUtils.toString(bool2, "on", "off");
    }

    public static String toStringYesNo(boolean bool2) {
        return BooleanUtils.toString(bool2, "yes", "no");
    }

    public static String toString(boolean bool2, String trueString, String falseString) {
        return bool2 ? trueString : falseString;
    }

    public static boolean xor(boolean[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        int trueCount = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            if (trueCount < 1) {
                ++trueCount;
                continue;
            }
            return false;
        }
        return trueCount == 1;
    }

    public static Boolean xor(Boolean[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean[] primitive = null;
        try {
            primitive = ArrayUtils.toPrimitive(array);
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
        return BooleanUtils.xor(primitive) ? Boolean.TRUE : Boolean.FALSE;
    }
}

