/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public final class PropertyConverter {
    static final char LIST_ESC_CHAR = '\\';
    static final String LIST_ESCAPE = String.valueOf('\\');
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_RADIX = 16;
    private static final float JAVA_VERSION_1_5 = 1.5f;
    private static final Class[] CONSTR_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PropertyConverter.class$("java.lang.String")) : class$java$lang$String};
    private static final String INTERNET_ADDRESS_CLASSNAME = "javax.mail.internet.InternetAddress";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$java$lang$Class;

    private PropertyConverter() {
    }

    static Object to(Class cls, Object value2, Object[] params) throws ConversionException {
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(cls) || Boolean.TYPE.equals(cls)) {
            return PropertyConverter.toBoolean(value2);
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = PropertyConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(cls) || cls.isPrimitive()) {
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyConverter.class$("java.lang.Integer")) : class$java$lang$Integer).equals(cls) || Integer.TYPE.equals(cls)) {
                return PropertyConverter.toInteger(value2);
            }
            if ((class$java$lang$Long == null ? (class$java$lang$Long = PropertyConverter.class$("java.lang.Long")) : class$java$lang$Long).equals(cls) || Long.TYPE.equals(cls)) {
                return PropertyConverter.toLong(value2);
            }
            if ((class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyConverter.class$("java.lang.Byte")) : class$java$lang$Byte).equals(cls) || Byte.TYPE.equals(cls)) {
                return PropertyConverter.toByte(value2);
            }
            if ((class$java$lang$Short == null ? (class$java$lang$Short = PropertyConverter.class$("java.lang.Short")) : class$java$lang$Short).equals(cls) || Short.TYPE.equals(cls)) {
                return PropertyConverter.toShort(value2);
            }
            if ((class$java$lang$Float == null ? (class$java$lang$Float = PropertyConverter.class$("java.lang.Float")) : class$java$lang$Float).equals(cls) || Float.TYPE.equals(cls)) {
                return PropertyConverter.toFloat(value2);
            }
            if ((class$java$lang$Double == null ? (class$java$lang$Double = PropertyConverter.class$("java.lang.Double")) : class$java$lang$Double).equals(cls) || Double.TYPE.equals(cls)) {
                return PropertyConverter.toDouble(value2);
            }
            if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger).equals(cls)) {
                return PropertyConverter.toBigInteger(value2);
            }
            if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(cls)) {
                return PropertyConverter.toBigDecimal(value2);
            }
        } else {
            if ((class$java$util$Date == null ? (class$java$util$Date = PropertyConverter.class$("java.util.Date")) : class$java$util$Date).equals(cls)) {
                return PropertyConverter.toDate(value2, (String)params[0]);
            }
            if ((class$java$util$Calendar == null ? (class$java$util$Calendar = PropertyConverter.class$("java.util.Calendar")) : class$java$util$Calendar).equals(cls)) {
                return PropertyConverter.toCalendar(value2, (String)params[0]);
            }
            if ((class$java$net$URL == null ? (class$java$net$URL = PropertyConverter.class$("java.net.URL")) : class$java$net$URL).equals(cls)) {
                return PropertyConverter.toURL(value2);
            }
            if ((class$java$util$Locale == null ? (class$java$util$Locale = PropertyConverter.class$("java.util.Locale")) : class$java$util$Locale).equals(cls)) {
                return PropertyConverter.toLocale(value2);
            }
            if (PropertyConverter.isEnum(cls)) {
                return PropertyConverter.toEnum(value2, cls);
            }
            if ((class$java$awt$Color == null ? (class$java$awt$Color = PropertyConverter.class$("java.awt.Color")) : class$java$awt$Color).equals(cls)) {
                return PropertyConverter.toColor(value2);
            }
            if (cls.getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
                return PropertyConverter.toInternetAddress(value2);
            }
            if ((class$java$net$InetAddress == null ? (class$java$net$InetAddress = PropertyConverter.class$("java.net.InetAddress")) : class$java$net$InetAddress).isAssignableFrom(cls)) {
                return PropertyConverter.toInetAddress(value2);
            }
        }
        throw new ConversionException("The value '" + value2 + "' (" + value2.getClass() + ")" + " can't be converted to a " + cls.getName() + " object");
    }

    public static Boolean toBoolean(Object value2) throws ConversionException {
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof String) {
            Boolean b = BooleanUtils.toBooleanObject((String)value2);
            if (b == null) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Boolean object");
            }
            return b;
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Boolean object");
    }

    public static Byte toByte(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyConverter.class$("java.lang.Byte")) : class$java$lang$Byte);
        if (n instanceof Byte) {
            return (Byte)n;
        }
        return new Byte(n.byteValue());
    }

    public static Short toShort(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$lang$Short == null ? (class$java$lang$Short = PropertyConverter.class$("java.lang.Short")) : class$java$lang$Short);
        if (n instanceof Short) {
            return (Short)n;
        }
        return new Short(n.shortValue());
    }

    public static Integer toInteger(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyConverter.class$("java.lang.Integer")) : class$java$lang$Integer);
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return new Integer(n.intValue());
    }

    public static Long toLong(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$lang$Long == null ? (class$java$lang$Long = PropertyConverter.class$("java.lang.Long")) : class$java$lang$Long);
        if (n instanceof Long) {
            return (Long)n;
        }
        return new Long(n.longValue());
    }

    public static Float toFloat(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$lang$Float == null ? (class$java$lang$Float = PropertyConverter.class$("java.lang.Float")) : class$java$lang$Float);
        if (n instanceof Float) {
            return (Float)n;
        }
        return new Float(n.floatValue());
    }

    public static Double toDouble(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$lang$Double == null ? (class$java$lang$Double = PropertyConverter.class$("java.lang.Double")) : class$java$lang$Double);
        if (n instanceof Double) {
            return (Double)n;
        }
        return new Double(n.doubleValue());
    }

    public static BigInteger toBigInteger(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public static BigDecimal toBigDecimal(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.doubleValue());
    }

    static Number toNumber(Object value2, Class targetClass) throws ConversionException {
        if (value2 instanceof Number) {
            return (Number)value2;
        }
        String str = value2.toString();
        if (str.startsWith(HEX_PREFIX)) {
            try {
                return new BigInteger(str.substring(HEX_PREFIX.length()), 16);
            }
            catch (NumberFormatException nex) {
                throw new ConversionException("Could not convert " + str + " to " + targetClass.getName() + "! Invalid hex number.", nex);
            }
        }
        try {
            Constructor constr = targetClass.getConstructor(CONSTR_ARGS);
            return (Number)constr.newInstance(str);
        }
        catch (InvocationTargetException itex) {
            throw new ConversionException("Could not convert " + str + " to " + targetClass.getName(), itex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException("Conversion error when trying to convert " + str + " to " + targetClass.getName(), ex);
        }
    }

    public static URL toURL(Object value2) throws ConversionException {
        if (value2 instanceof URL) {
            return (URL)value2;
        }
        if (value2 instanceof String) {
            try {
                return new URL((String)value2);
            }
            catch (MalformedURLException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to an URL", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to an URL");
    }

    public static Locale toLocale(Object value2) throws ConversionException {
        if (value2 instanceof Locale) {
            return (Locale)value2;
        }
        if (value2 instanceof String) {
            List elements = PropertyConverter.split((String)value2, '_');
            int size2 = elements.size();
            if (size2 >= 1 && (((String)elements.get(0)).length() == 2 || ((String)elements.get(0)).length() == 0)) {
                String language = (String)elements.get(0);
                String country = size2 >= 2 ? elements.get(1) : "";
                String variant = size2 >= 3 ? elements.get(2) : "";
                return new Locale(language, country, variant);
            }
            throw new ConversionException("The value " + value2 + " can't be converted to a Locale");
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Locale");
    }

    public static List split(String s, char delimiter, boolean trim2) {
        if (s == null) {
            return new ArrayList();
        }
        ArrayList<String> list2 = new ArrayList<String>();
        StringBuffer token2 = new StringBuffer();
        boolean inEscape = false;
        for (int begin = 0; begin < s.length(); ++begin) {
            char c = s.charAt(begin);
            if (inEscape) {
                if (c != delimiter && c != '\\') {
                    token2.append('\\');
                }
                token2.append(c);
                inEscape = false;
                continue;
            }
            if (c == delimiter) {
                String t = token2.toString();
                if (trim2) {
                    t = t.trim();
                }
                list2.add(t);
                token2 = new StringBuffer();
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            token2.append(c);
        }
        if (inEscape) {
            token2.append('\\');
        }
        String t = token2.toString();
        if (trim2) {
            t = t.trim();
        }
        list2.add(t);
        return list2;
    }

    public static List split(String s, char delimiter) {
        return PropertyConverter.split(s, delimiter, true);
    }

    public static String escapeDelimiters(String s, char delimiter) {
        String s1 = StringUtils.replace(s, LIST_ESCAPE, LIST_ESCAPE + LIST_ESCAPE);
        return StringUtils.replace(s1, String.valueOf(delimiter), LIST_ESCAPE + delimiter);
    }

    public static Color toColor(Object value2) throws ConversionException {
        if (value2 instanceof Color) {
            return (Color)value2;
        }
        if (value2 instanceof String && !StringUtils.isBlank((String)value2)) {
            String color = ((String)value2).trim();
            int[] components = new int[3];
            int minlength = components.length * 2;
            if (color.length() < minlength) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Color");
            }
            if (color.startsWith("#")) {
                color = color.substring(1);
            }
            try {
                for (int i = 0; i < components.length; ++i) {
                    components[i] = Integer.parseInt(color.substring(2 * i, 2 * i + 2), 16);
                }
                int alpha = color.length() >= minlength + 2 ? Integer.parseInt(color.substring(minlength, minlength + 2), 16) : Color.black.getAlpha();
                return new Color(components[0], components[1], components[2], alpha);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Color", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Color");
    }

    static InetAddress toInetAddress(Object value2) throws ConversionException {
        if (value2 instanceof InetAddress) {
            return (InetAddress)value2;
        }
        if (value2 instanceof String) {
            try {
                return InetAddress.getByName((String)value2);
            }
            catch (UnknownHostException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a InetAddress", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a InetAddress");
    }

    static Object toInternetAddress(Object value2) throws ConversionException {
        if (value2.getClass().getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
            return value2;
        }
        if (value2 instanceof String) {
            try {
                Constructor<?> ctor = Class.forName(INTERNET_ADDRESS_CLASSNAME).getConstructor(class$java$lang$String == null ? (class$java$lang$String = PropertyConverter.class$("java.lang.String")) : class$java$lang$String);
                return ctor.newInstance(value2);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a InternetAddress", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a InternetAddress");
    }

    static boolean isEnum(Class cls) {
        if (!SystemUtils.isJavaVersionAtLeast(1.5f)) {
            return false;
        }
        try {
            Method isEnumMethod = (class$java$lang$Class == null ? (class$java$lang$Class = PropertyConverter.class$("java.lang.Class")) : class$java$lang$Class).getMethod("isEnum", new Class[0]);
            return (Boolean)isEnumMethod.invoke((Object)cls, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static Object toEnum(Object value2, Class cls) throws ConversionException {
        if (value2.getClass().equals(cls)) {
            return value2;
        }
        if (value2 instanceof String) {
            try {
                Method valueOfMethod = cls.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = PropertyConverter.class$("java.lang.String")) : class$java$lang$String);
                return valueOfMethod.invoke(null, value2);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a " + cls.getName());
            }
        }
        if (value2 instanceof Number) {
            try {
                Method valuesMethod = cls.getMethod("values", new Class[0]);
                Object valuesArray = valuesMethod.invoke(null, new Object[0]);
                return Array.get(valuesArray, ((Number)value2).intValue());
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a " + cls.getName());
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a " + cls.getName());
    }

    public static Date toDate(Object value2, String format2) throws ConversionException {
        if (value2 instanceof Date) {
            return (Date)value2;
        }
        if (value2 instanceof Calendar) {
            return ((Calendar)value2).getTime();
        }
        if (value2 instanceof String) {
            try {
                return new SimpleDateFormat(format2).parse((String)value2);
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Date", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Date");
    }

    public static Calendar toCalendar(Object value2, String format2) throws ConversionException {
        if (value2 instanceof Calendar) {
            return (Calendar)value2;
        }
        if (value2 instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value2);
            return calendar;
        }
        if (value2 instanceof String) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format2).parse((String)value2));
                return calendar;
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Calendar", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Calendar");
    }

    public static Iterator toIterator(Object value2, char delimiter) {
        if (value2 == null) {
            return IteratorUtils.emptyIterator();
        }
        if (value2 instanceof String) {
            String s = (String)value2;
            if (s.indexOf(delimiter) > 0) {
                return PropertyConverter.split((String)value2, delimiter).iterator();
            }
            return new SingletonIterator(value2);
        }
        if (value2 instanceof Collection) {
            return PropertyConverter.toIterator(((Collection)value2).iterator(), delimiter);
        }
        if (value2.getClass().isArray()) {
            return PropertyConverter.toIterator(IteratorUtils.arrayIterator(value2), delimiter);
        }
        if (value2 instanceof Iterator) {
            Iterator iterator2 = (Iterator)value2;
            IteratorChain chain2 = new IteratorChain();
            while (iterator2.hasNext()) {
                chain2.addIterator(PropertyConverter.toIterator(iterator2.next(), delimiter));
            }
            return chain2;
        }
        return new SingletonIterator(value2);
    }

    public static Object interpolate(Object value2, AbstractConfiguration config) {
        if (value2 instanceof String) {
            return config.getSubstitutor().replace((String)value2);
        }
        return value2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

