/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class StringArrayConverter
extends AbstractArrayConverter {
    private static final String[] MODEL = new String[0];
    private static final int[] INT_MODEL = new int[0];

    public StringArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public StringArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (MODEL.getClass() == value2.getClass()) {
            return value2;
        }
        if (INT_MODEL.getClass() == value2.getClass()) {
            int[] values2 = (int[])value2;
            String[] results = new String[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                results[i] = Integer.toString(values2[i]);
            }
            return results;
        }
        try {
            List list2 = this.parseElements(value2.toString());
            String[] results = new String[list2.size()];
            for (int i = 0; i < results.length; ++i) {
                results[i] = (String)list2.get(i);
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value2.toString(), e);
        }
    }
}

