/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

abstract class JDBCDynaClass
implements DynaClass,
Serializable {
    protected boolean lowerCase = true;
    protected DynaProperty[] properties = null;
    protected Map propertiesMap = new HashMap();
    private Map columnNameXref;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Object;

    JDBCDynaClass() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    protected Class loadClass(String className) throws SQLException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return cl.loadClass(className);
        }
        catch (Exception e) {
            throw new SQLException("Cannot load column class '" + className + "': " + e);
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
        Class clazz;
        String name;
        String columnName = metadata.getColumnName(i);
        String string2 = name = this.lowerCase ? columnName.toLowerCase() : columnName;
        if (!name.equals(columnName)) {
            if (this.columnNameXref == null) {
                this.columnNameXref = new HashMap();
            }
            this.columnNameXref.put(name, columnName);
        }
        String className = null;
        try {
            int sqlType = metadata.getColumnType(i);
            switch (sqlType) {
                case 91: {
                    return new DynaProperty(name, class$java$sql$Date == null ? (class$java$sql$Date = JDBCDynaClass.class$("java.sql.Date")) : class$java$sql$Date);
                }
                case 93: {
                    return new DynaProperty(name, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDBCDynaClass.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
                }
                case 92: {
                    return new DynaProperty(name, class$java$sql$Time == null ? (class$java$sql$Time = JDBCDynaClass.class$("java.sql.Time")) : class$java$sql$Time);
                }
            }
            className = metadata.getColumnClassName(i);
        }
        catch (SQLException e) {
            // empty catch block
        }
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = JDBCDynaClass.class$("java.lang.Object")) : class$java$lang$Object;
        if (className != null) {
            clazz = this.loadClass(className);
        }
        return new DynaProperty(name, clazz);
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        int i;
        ArrayList<DynaProperty> list2 = new ArrayList<DynaProperty>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int n = metadata.getColumnCount();
        for (i = 1; i <= n; ++i) {
            DynaProperty dynaProperty = this.createDynaProperty(metadata, i);
            if (dynaProperty == null) continue;
            list2.add(dynaProperty);
        }
        this.properties = list2.toArray(new DynaProperty[list2.size()]);
        for (i = 0; i < this.properties.length; ++i) {
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
    }

    protected Object getObject(ResultSet resultSet, String name) throws SQLException {
        DynaProperty property = this.getDynaProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Invalid name '" + name + "'");
        }
        String columnName = this.getColumnName(name);
        Class type = property.getType();
        if (type.equals(class$java$sql$Date == null ? (class$java$sql$Date = JDBCDynaClass.class$("java.sql.Date")) : class$java$sql$Date)) {
            return resultSet.getDate(columnName);
        }
        if (type.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDBCDynaClass.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return resultSet.getTimestamp(columnName);
        }
        if (type.equals(class$java$sql$Time == null ? (class$java$sql$Time = JDBCDynaClass.class$("java.sql.Time")) : class$java$sql$Time)) {
            return resultSet.getTime(columnName);
        }
        return resultSet.getObject(columnName);
    }

    protected String getColumnName(String name) {
        if (this.columnNameXref != null && this.columnNameXref.containsKey(name)) {
            return (String)this.columnNameXref.get(name);
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

