/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.EdgeFactory;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.ListenableGraph;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.event.GraphEdgeChangeEvent;
import org._3pq.jgrapht.event.GraphListener;
import org._3pq.jgrapht.event.GraphVertexChangeEvent;
import org._3pq.jgrapht.graph.AbstractGraph;

public class Subgraph
extends AbstractGraph
implements Serializable {
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    Set m_edgeSet = new LinkedHashSet();
    Set m_vertexSet = new LinkedHashSet();
    private transient Set m_unmodifiableEdgeSet = null;
    private transient Set m_unmodifiableVertexSet = null;
    private Graph m_base;
    private boolean m_isInduced = false;
    private boolean m_verifyIntegrity = true;

    public Subgraph(Graph graph, Set set, Set set2) {
        this.m_base = graph;
        if (this.m_base instanceof ListenableGraph) {
            ((ListenableGraph)this.m_base).addGraphListener(new BaseGraphListener());
        }
        this.addVerticesUsingFilter(graph.vertexSet(), set);
        this.addEdgesUsingFilter(graph.edgeSet(), set2);
    }

    public Subgraph(Graph graph, Set set) {
        this(graph, set, null);
        this.m_isInduced = true;
    }

    public List getAllEdges(Object object, Object object2) {
        ArrayList<Edge> arrayList = null;
        if (this.containsVertex(object) && this.containsVertex(object2)) {
            arrayList = new ArrayList<Edge>();
            List list2 = this.m_base.getAllEdges(object, object2);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                if (!this.m_edgeSet.contains(edge)) continue;
                arrayList.add(edge);
            }
        }
        return arrayList;
    }

    public Edge getEdge(Object object, Object object2) {
        List list2 = this.getAllEdges(object, object2);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return (Edge)list2.get(0);
    }

    public EdgeFactory getEdgeFactory() {
        return this.m_base.getEdgeFactory();
    }

    public void setVerifyIntegrity(boolean bl) {
        this.m_verifyIntegrity = bl;
    }

    public boolean isVerifyIntegrity() {
        return this.m_verifyIntegrity;
    }

    public Edge addEdge(Object object, Object object2) {
        this.assertVertexExist(object);
        this.assertVertexExist(object2);
        if (!this.m_base.containsEdge(object, object2)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        List list2 = this.m_base.getAllEdges(object, object2);
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            if (this.containsEdge(edge)) continue;
            this.m_edgeSet.add(edge);
            return edge;
        }
        return null;
    }

    public boolean addEdge(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        if (!this.m_base.containsEdge(edge)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(edge.getSource());
        this.assertVertexExist(edge.getTarget());
        if (this.containsEdge(edge)) {
            return false;
        }
        this.m_edgeSet.add(edge);
        return true;
    }

    public boolean addVertex(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!this.m_base.containsVertex(object)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        if (this.containsVertex(object)) {
            return false;
        }
        this.m_vertexSet.add(object);
        return true;
    }

    public boolean containsEdge(Edge edge) {
        return this.m_edgeSet.contains(edge);
    }

    public boolean containsVertex(Object object) {
        return this.m_vertexSet.contains(object);
    }

    public int degreeOf(Object object) {
        this.assertVertexExist(object);
        ((UndirectedGraph)this.m_base).degreeOf(object);
        int n = 0;
        Iterator iterator2 = this.m_base.edgesOf(object).iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            if (!this.containsEdge(edge)) continue;
            ++n;
            if (!edge.getSource().equals(edge.getTarget())) continue;
            ++n;
        }
        return n;
    }

    public Set edgeSet() {
        if (this.m_unmodifiableEdgeSet == null) {
            this.m_unmodifiableEdgeSet = Collections.unmodifiableSet(this.m_edgeSet);
        }
        return this.m_unmodifiableEdgeSet;
    }

    public List edgesOf(Object object) {
        this.assertVertexExist(object);
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        List list2 = this.m_base.edgesOf(object);
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            if (!this.containsEdge(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    public int inDegreeOf(Object object) {
        this.assertVertexExist(object);
        int n = 0;
        Iterator iterator2 = ((DirectedGraph)this.m_base).incomingEdgesOf(object).iterator();
        while (iterator2.hasNext()) {
            if (!this.containsEdge((Edge)iterator2.next())) continue;
            ++n;
        }
        return n;
    }

    public List incomingEdgesOf(Object object) {
        this.assertVertexExist(object);
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        List list2 = ((DirectedGraph)this.m_base).incomingEdgesOf(object);
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            if (!this.containsEdge(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    public int outDegreeOf(Object object) {
        this.assertVertexExist(object);
        int n = 0;
        Iterator iterator2 = ((DirectedGraph)this.m_base).outgoingEdgesOf(object).iterator();
        while (iterator2.hasNext()) {
            if (!this.containsEdge((Edge)iterator2.next())) continue;
            ++n;
        }
        return n;
    }

    public List outgoingEdgesOf(Object object) {
        this.assertVertexExist(object);
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        List list2 = ((DirectedGraph)this.m_base).outgoingEdgesOf(object);
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            if (!this.containsEdge(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    public boolean removeEdge(Edge edge) {
        return this.m_edgeSet.remove(edge);
    }

    public Edge removeEdge(Object object, Object object2) {
        Edge edge = this.getEdge(object, object2);
        return this.m_edgeSet.remove(edge) ? edge : null;
    }

    public boolean removeVertex(Object object) {
        if (this.containsVertex(object) && this.m_base.containsVertex(object)) {
            this.removeAllEdges(this.edgesOf(object));
        }
        return this.m_vertexSet.remove(object);
    }

    public Set vertexSet() {
        if (this.m_unmodifiableVertexSet == null) {
            this.m_unmodifiableVertexSet = Collections.unmodifiableSet(this.m_vertexSet);
        }
        return this.m_unmodifiableVertexSet;
    }

    private void addEdgesUsingFilter(Set set, Set set2) {
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Edge edge = (Edge)iterator2.next();
            boolean bl2 = this.containsVertex(edge.getSource()) && this.containsVertex(edge.getTarget());
            boolean bl3 = bl = set2 == null || set2.contains(edge);
            if (!bl2 || !bl) continue;
            this.addEdge(edge);
        }
    }

    private void addVerticesUsingFilter(Set set, Set set2) {
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            if (set2 != null && !set2.contains(e)) continue;
            this.addVertex(e);
        }
    }

    private class BaseGraphListener
    implements GraphListener,
    Serializable {
        private BaseGraphListener() {
        }

        public void edgeAdded(GraphEdgeChangeEvent graphEdgeChangeEvent) {
            if (Subgraph.this.m_isInduced) {
                Subgraph.this.addEdge(graphEdgeChangeEvent.getEdge());
            }
        }

        public void edgeRemoved(GraphEdgeChangeEvent graphEdgeChangeEvent) {
            Edge edge = graphEdgeChangeEvent.getEdge();
            Subgraph.this.removeEdge(edge);
        }

        public void vertexAdded(GraphVertexChangeEvent graphVertexChangeEvent) {
        }

        public void vertexRemoved(GraphVertexChangeEvent graphVertexChangeEvent) {
            Object object = graphVertexChangeEvent.getVertex();
            Subgraph.this.removeVertex(object);
        }
    }
}

