/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.ext.JGraphModelAdapter;
import org._3pq.jgrapht.graph.DefaultListenableGraph;
import org._3pq.jgrapht.graph.DirectedMultigraph;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;

public class JGraphAdapterDemo
extends JApplet {
    private static final long serialVersionUID = 3256444702936019250L;
    private static final Color DEFAULT_BG_COLOR = Color.decode("#FAFBFF");
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private JGraphModelAdapter m_jgAdapter;

    public static void main(String[] stringArray) {
        JGraphAdapterDemo jGraphAdapterDemo = new JGraphAdapterDemo();
        jGraphAdapterDemo.init();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(jGraphAdapterDemo);
        jFrame.setTitle("JGraphT Adapter to JGraph Demo");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void init() {
        ListenableDirectedMultigraph listenableDirectedMultigraph = new ListenableDirectedMultigraph();
        this.m_jgAdapter = new JGraphModelAdapter(listenableDirectedMultigraph);
        JGraph jGraph = new JGraph((GraphModel)this.m_jgAdapter);
        this.adjustDisplaySettings(jGraph);
        this.getContentPane().add((Component)jGraph);
        this.resize(DEFAULT_SIZE);
        String string2 = "v1";
        String string3 = "v2";
        String string4 = "v3";
        String string5 = "v4";
        listenableDirectedMultigraph.addVertex(string2);
        listenableDirectedMultigraph.addVertex(string3);
        listenableDirectedMultigraph.addVertex(string4);
        listenableDirectedMultigraph.addVertex(string5);
        listenableDirectedMultigraph.addEdge(string2, string3);
        listenableDirectedMultigraph.addEdge(string3, string4);
        listenableDirectedMultigraph.addEdge(string4, string2);
        listenableDirectedMultigraph.addEdge(string5, string4);
        this.positionVertexAt(string2, 130, 40);
        this.positionVertexAt(string3, 60, 200);
        this.positionVertexAt(string4, 310, 230);
        this.positionVertexAt(string5, 380, 70);
    }

    private void adjustDisplaySettings(JGraph jGraph) {
        jGraph.setPreferredSize(DEFAULT_SIZE);
        Color color = DEFAULT_BG_COLOR;
        String string2 = null;
        try {
            string2 = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            color = Color.decode(string2);
        }
        jGraph.setBackground(color);
    }

    private void positionVertexAt(Object object, int n, int n2) {
        DefaultGraphCell defaultGraphCell = this.m_jgAdapter.getVertexCell(object);
        AttributeMap attributeMap = defaultGraphCell.getAttributes();
        Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, rectangle2D.getWidth(), rectangle2D.getHeight());
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)double_);
        AttributeMap attributeMap2 = new AttributeMap();
        attributeMap2.put((Object)defaultGraphCell, (Object)attributeMap);
        this.m_jgAdapter.edit((Map)attributeMap2, null, null, null);
    }

    private static class ListenableDirectedMultigraph
    extends DefaultListenableGraph
    implements DirectedGraph {
        private static final long serialVersionUID = 1L;

        ListenableDirectedMultigraph() {
            super(new DirectedMultigraph());
        }
    }
}

