/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class CasConsumerUtil {
    private CasConsumerUtil() {
    }

    public static InputStream getOptionalResourceAsStream(UimaContext context, String name) throws ResourceInitializationException {
        try {
            return context.getResourceAsStream(name);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"There is an internal error in the UIMA SDK: " + e.getMessage(), e});
        }
    }

    public static InputStream getResourceAsStream(UimaContext context, String name) throws ResourceInitializationException {
        InputStream inResource = CasConsumerUtil.getOptionalResourceAsStream(context, name);
        if (inResource == null) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"Unable to load resource!"});
        }
        return inResource;
    }

    public static Type getType(TypeSystem typeSystem, String name) throws ResourceInitializationException {
        Type type = CasConsumerUtil.getOptionalType(typeSystem, name);
        if (type == null) {
            throw new ResourceInitializationException("incompatible_range_types", new Object[]{"Unable to retrive " + name + " type!"});
        }
        return type;
    }

    public static Type getOptionalType(TypeSystem typeSystem, String name) throws ResourceInitializationException {
        return typeSystem.getType(name);
    }

    public static String getRequiredStringParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        String value2 = CasConsumerUtil.getOptionalStringParameter(context, parameter);
        CasConsumerUtil.checkForNull(value2, parameter);
        return value2;
    }

    public static Integer getRequiredIntegerParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Integer value2 = CasConsumerUtil.getOptionalIntegerParameter(context, parameter);
        CasConsumerUtil.checkForNull(value2, parameter);
        return value2;
    }

    public static Float getRequiredFloatParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Float value2 = CasConsumerUtil.getOptionalFloatParameter(context, parameter);
        CasConsumerUtil.checkForNull(value2, parameter);
        return value2;
    }

    public static Boolean getRequiredBooleanParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Boolean value2 = CasConsumerUtil.getOptionalBooleanParameter(context, parameter);
        CasConsumerUtil.checkForNull(value2, parameter);
        return value2;
    }

    private static void checkForNull(Object value2, String parameterName) throws ResourceInitializationException {
        if (value2 == null) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The " + parameterName + " is a " + "requiered parameter!"});
        }
    }

    public static String getOptionalStringParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value2 = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type String"});
    }

    public static String[] getOptionalStringArrayParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value2 = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value2 instanceof String[]) {
            return (String[])value2;
        }
        if (value2 == null) {
            return new String[0];
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type String array"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value2 = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type Integer"});
    }

    public static Float getOptionalFloatParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value2 = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Float) {
            return (Float)value2;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type Float"});
    }

    public static Boolean getOptionalBooleanParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value2 = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type Boolean"});
    }

    private static Object getOptionalParameter(UimaContext context, String parameter) {
        Object value2 = context.getConfigParameterValue(parameter);
        Logger logger = context.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, parameter + " = " + (value2 != null ? value2.toString() : "not set"));
        }
        return value2;
    }

    public static void checkFeatureType(Feature feature, String expectedType) throws ResourceInitializationException {
        if (!feature.getRange().getName().equals(expectedType)) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The Feature " + feature.getName() + " must be of type " + expectedType + " !"});
        }
    }

    public static Dictionary createOptionalDictionary(UimaContext context, String parameter) throws ResourceInitializationException {
        String dictionaryName = CasConsumerUtil.getOptionalStringParameter(context, parameter);
        Dictionary dictionary = null;
        if (dictionaryName != null) {
            block7: {
                Logger logger = context.getLogger();
                try {
                    InputStream dictIn = CasConsumerUtil.getOptionalResourceAsStream(context, dictionaryName);
                    if (dictIn == null) {
                        String message = "The dictionary file " + dictionaryName + " does not exist!";
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, message);
                        }
                        return null;
                    }
                    dictionary = new Dictionary(dictIn);
                }
                catch (IOException e) {
                    String message = "IOException during dictionary reading, running without dictionary: " + e.getMessage();
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, message);
                    }
                }
                catch (InvalidFormatException e) {
                    String message = "Invalid dictionary format, running without dictionary: " + e.getMessage();
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.log(Level.WARNING, message);
                }
            }
            return dictionary;
        }
        return null;
    }
}

