/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.sentdetect;

import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.uima.sentdetect.AbstractSentenceDetector;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public final class SentenceDetector
extends AbstractSentenceDetector {
    private SentenceDetectorME sentenceDetector;
    private Feature probabilityFeature;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.sentenceDetector = new SentenceDetectorME(OpennlpUtil.createModel(context, UimaUtil.MODEL_PARAMETER));
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptinoalFeatureParameter(this.context, this.sentenceType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    protected int[] detectSentences(String text2) {
        return this.sentenceDetector.sentPosDetect(text2);
    }

    protected void postProcessAnnotations(AnnotationFS[] sentences) {
        if (this.probabilityFeature != null) {
            double[] sentenceProbabilities = this.sentenceDetector.getSentenceProbabilities();
            for (int i = 0; i < sentences.length; ++i) {
                sentences[i].setDoubleValue(this.probabilityFeature, sentenceProbabilities[i]);
            }
        }
    }

    public void destroy() {
        this.sentenceDetector = null;
    }
}

