/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.sentdetect;

import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.StringUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class AbstractSentenceDetector
extends CasAnnotator_ImplBase {
    protected UimaContext context;
    protected Logger logger;
    protected Type containerType;
    protected Type sentenceType;
    private Boolean isRemoveExistingAnnotations;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.context = context;
        this.logger = context.getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the OpenNLP Sentence annotator.");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(context, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.containerType = AnnotatorUtil.getOptionalTypeParameter(this.context, typeSystem, "opennlp.uima.ContainerType");
        if (this.containerType == null) {
            this.containerType = typeSystem.getType("uima.tcas.DocumentAnnotation");
        }
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
    }

    protected abstract int[] detectSentences(String var1);

    protected void postProcessAnnotations(AnnotationFS[] sentences) {
    }

    private static boolean isWhitespace(char theChar) {
        boolean result2;
        switch (theChar) {
            case ' ': {
                result2 = true;
                break;
            }
            case '\n': {
                result2 = true;
                break;
            }
            default: {
                result2 = false;
            }
        }
        return result2;
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        AnnotationIndex<AnnotationFS> containerAnnotations = cas.getAnnotationIndex(this.containerType);
        for (AnnotationFS containerAnnotation : containerAnnotations) {
            String text2 = containerAnnotation.getCoveredText();
            if (this.isRemoveExistingAnnotations.booleanValue()) {
                UimaUtil.removeAnnotations(cas, containerAnnotation, this.sentenceType);
            }
            int[] sentPositions = this.detectSentences(text2);
            AnnotationFS[] sentences = new AnnotationFS[sentPositions.length];
            int begin = 0;
            for (int i = 0; i < sentPositions.length; ++i) {
                int j;
                int end = sentPositions[i];
                for (j = begin; j < end && StringUtil.isWhitespace(text2.charAt(j)); ++j) {
                    begin = j + 1;
                }
                if (end > 1) {
                    for (j = end; j > begin && StringUtil.isWhitespace(text2.charAt(j - 1)); --j) {
                        end = j - 1;
                    }
                }
                sentences[i] = cas.createAnnotation(this.sentenceType, begin + containerAnnotation.getBegin(), end + containerAnnotation.getBegin());
                cas.getIndexRepository().addFS(sentences[i]);
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "\"" + sentences[i].getCoveredText() + "\"");
                }
                begin = end;
            }
            this.postProcessAnnotations(sentences);
        }
    }
}

