/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.postag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import opennlp.maxent.MaxentModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.InvalidFormatException;
import opennlp.uima.util.AnnotationComboIterator;
import opennlp.uima.util.AnnotationIteratorPair;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class POSTagger
extends CasAnnotator_ImplBase {
    private static final String DICTIONARY_NAME = "opennlp.uima.DictionaryName";
    private static final String TAG_DICTIONARY_NAME = "opennlp.uima.TagDictionaryName";
    private POSTaggerME posTagger;
    private Type sentenceType;
    private Type tokenType;
    private Feature posFeature;
    private Feature probabilityFeature;
    private UimaContext context;
    private Logger logger;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        Integer beamSize;
        POSDictionary tagDictionary;
        Dictionary ngramDictionary;
        MaxentModel model;
        block10: {
            block9: {
                this.context = context;
                this.logger = context.getLogger();
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Initializing the OpenNLP Part-Of-Speech annotator.");
                }
                model = OpennlpUtil.createModel(context, UimaUtil.MODEL_PARAMETER);
                String dictionaryName = AnnotatorUtil.getOptionalStringParameter(context, DICTIONARY_NAME);
                ngramDictionary = null;
                if (dictionaryName != null) {
                    String message;
                    try {
                        InputStream dictIn = AnnotatorUtil.getResourceAsStream(context, dictionaryName);
                        ngramDictionary = new Dictionary(dictIn);
                    }
                    catch (IOException e) {
                        message = "IOException during dictionary reading, running without dictionary: " + e.getMessage();
                        if (this.logger.isLoggable(Level.WARNING)) {
                            this.logger.log(Level.WARNING, message);
                        }
                    }
                    catch (InvalidFormatException e) {
                        message = "Invalid dictionary format, running without dictionary: " + e.getMessage();
                        if (!this.logger.isLoggable(Level.WARNING)) break block9;
                        this.logger.log(Level.WARNING, message);
                    }
                }
            }
            String tagDictionaryName = AnnotatorUtil.getOptionalStringParameter(context, TAG_DICTIONARY_NAME);
            tagDictionary = null;
            if (tagDictionary != null) {
                try {
                    InputStream dictIn = AnnotatorUtil.getResourceAsStream(context, tagDictionaryName);
                    tagDictionary = new POSDictionary(new BufferedReader(new InputStreamReader(dictIn)), false);
                }
                catch (IOException e) {
                    String message = "IOException during tag dictionary reading, running without tag dictionary: " + e.getMessage();
                    if (!this.logger.isLoggable(Level.WARNING)) break block10;
                    this.logger.log(Level.WARNING, message);
                }
            }
        }
        this.posTagger = (beamSize = AnnotatorUtil.getOptionalIntegerParameter(context, "opennlp.uima.BeamSize")) != null ? new POSTaggerME(beamSize, model, new DefaultPOSContextGenerator(ngramDictionary), tagDictionary) : new POSTaggerME(model, ngramDictionary, tagDictionary);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.tokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.posFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.tokenType, "opennlp.uima.POSFeature", "uima.cas.String");
        this.probabilityFeature = AnnotatorUtil.getOptinoalFeatureParameter(this.context, this.tokenType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    public void process(CAS tcas) {
        AnnotationComboIterator comboIterator = new AnnotationComboIterator(tcas, this.sentenceType, this.tokenType);
        for (AnnotationIteratorPair annotationIteratorPair : comboIterator) {
            LinkedList<AnnotationFS> sentenceTokenAnnotationList = new LinkedList<AnnotationFS>();
            LinkedList<String> sentenceTokenList = new LinkedList<String>();
            for (AnnotationFS tokenAnnotation : annotationIteratorPair.getSubIterator()) {
                sentenceTokenAnnotationList.add(tokenAnnotation);
                sentenceTokenList.add(tokenAnnotation.getCoveredText());
            }
            List posTags = this.posTagger.tag(sentenceTokenList);
            double[] posProbabilities = null;
            if (this.probabilityFeature != null) {
                posProbabilities = this.posTagger.probs();
            }
            Iterator posTagIterator = posTags.iterator();
            Iterator sentenceTokenIterator = sentenceTokenAnnotationList.iterator();
            int index = 0;
            while (posTagIterator.hasNext() && sentenceTokenIterator.hasNext()) {
                String posTag = (String)posTagIterator.next();
                AnnotationFS tokenAnnotation = (AnnotationFS)sentenceTokenIterator.next();
                tokenAnnotation.setStringValue(this.posFeature, posTag);
                if (posProbabilities != null) {
                    tokenAnnotation.setDoubleValue(this.posFeature, posProbabilities[index]);
                }
                ++index;
            }
            if (!this.logger.isLoggable(Level.FINER)) continue;
            StringBuilder sentenceWithPos = new StringBuilder();
            sentenceWithPos.append("\"");
            for (AnnotationFS token2 : sentenceTokenAnnotationList) {
                sentenceWithPos.append(token2.getCoveredText());
                sentenceWithPos.append('\\');
                sentenceWithPos.append(token2.getStringValue(this.posFeature));
                sentenceWithPos.append(' ');
            }
            sentenceWithPos.delete(sentenceWithPos.length() - 2, sentenceWithPos.length() - 2);
            sentenceWithPos.append("\"");
            this.logger.log(Level.FINER, sentenceWithPos.toString());
        }
    }

    public void destroy() {
        this.posTagger = null;
    }
}

