/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.parser.treeinsert;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.ParserChunker;
import opennlp.tools.parser.ParserTagger;
import opennlp.uima.parser.AbstractParser;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public final class Parser
extends AbstractParser {
    private static final String ATTACH_MODEL_PARAMETER = null;

    protected String getImplementationName() {
        return "OpenNLP Treeinserting Parser";
    }

    protected void initialize(MaxentModel buildModel, ParserTagger parserTagger, ParserChunker parserChunker, HeadRules headRules) throws ResourceInitializationException {
        GISModel attachModel;
        try {
            String attachModelName = AnnotatorUtil.getRequiredStringParameter(this.context, ATTACH_MODEL_PARAMETER);
            if (this.mLogger.isLoggable(Level.CONFIG)) {
                this.mLogger.log(Level.CONFIG, ATTACH_MODEL_PARAMETER + ": " + attachModelName);
            }
            InputStream attachModelIn = AnnotatorUtil.getResourceAsStream(this.context, attachModelName);
            attachModel = new BinaryGISModelReader(new DataInputStream(attachModelIn)).getModel();
        }
        catch (IOException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", new Object[]{e.getMessage(), e});
        }
        MaxentModel checkModel = null;
        this.mParser = new opennlp.tools.parser.treeinsert.Parser(buildModel, attachModel, checkModel, parserTagger, parserChunker, headRules);
    }
}

