/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.parser.chunking;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.ParserChunker;
import opennlp.tools.parser.ParserTagger;
import opennlp.uima.parser.AbstractParser;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public final class Parser
extends AbstractParser {
    private static final String CHECK_MODEL_PARAMETER = "opennlp.uima.parser.chunking.CheckModel";

    protected String getImplementationName() {
        return "OpenNLP Chunking Parser";
    }

    protected void initialize(MaxentModel buildModel, ParserTagger parserTagger, ParserChunker parserChunker, HeadRules headRules) throws ResourceInitializationException {
        GISModel checkModel;
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP chunking Parser annotator.");
        }
        try {
            String checkModelName = AnnotatorUtil.getRequiredStringParameter(this.context, CHECK_MODEL_PARAMETER);
            if (this.mLogger.isLoggable(Level.CONFIG)) {
                this.mLogger.log(Level.CONFIG, "opennlp.uima.parser.chunking.CheckModel: " + checkModelName);
            }
            InputStream checkModelIn = AnnotatorUtil.getResourceAsStream(this.context, checkModelName);
            checkModel = new BinaryGISModelReader(new DataInputStream(checkModelIn)).getModel();
        }
        catch (IOException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[]{e.getMessage(), e});
        }
        this.mParser = new opennlp.tools.parser.chunking.Parser(buildModel, checkModel, parserTagger, parserChunker, headRules);
    }
}

