/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import opennlp.tools.ngram.Token;
import opennlp.tools.ngram.TokenList;
import opennlp.tools.util.InvalidFormatException;
import opennlp.uima.normalizer.NumberUtil;
import opennlp.uima.normalizer.StringDictionary;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Normalizer
extends CasAnnotator_ImplBase {
    private static final Set SUPPORTED_TYPES;
    private UimaContext context;
    private Logger mLogger;
    private Type mNameType;
    private Feature mStructureFeature;
    private StringDictionary mLookupDictionary;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Normalizer annotator.");
        }
        try {
            String modelName = AnnotatorUtil.getOptionalStringParameter(context, "opennlp.uima.Dictionary");
            if (modelName != null) {
                InputStream inModel = AnnotatorUtil.getResourceAsStream(context, modelName);
                this.mLookupDictionary = new StringDictionary(inModel);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[0]);
        }
        catch (InvalidFormatException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "invalid_dictionary_format", new Object[0]);
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mNameType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.NameType");
        this.mStructureFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mNameType, "opennlp.uima.normalizer.StructureFeature");
        if (!SUPPORTED_TYPES.contains(this.mStructureFeature.getRange().getName())) {
            throw new AnalysisEngineProcessException("opennlp.uima.util.ExceptionMessages", "range_type_unsupported", new Object[]{this.mStructureFeature.getRange().getName()});
        }
    }

    public void process(CAS tcas) {
        AnnotationIndex<AnnotationFS> sentenceIndex = tcas.getAnnotationIndex(this.mNameType);
        for (AnnotationFS nameAnnotation : sentenceIndex) {
            Number number2;
            TokenList tokens;
            String normalizedText;
            String language = tcas.getDocumentLanguage();
            if (!NumberUtil.isLanguageSupported(language)) {
                if (!this.mLogger.isLoggable(Level.INFO)) continue;
                this.mLogger.log(Level.INFO, "Unsupported language: " + language);
                continue;
            }
            String text2 = nameAnnotation.getCoveredText();
            if (this.mLookupDictionary != null && (normalizedText = this.mLookupDictionary.get(tokens = new TokenList(new Token[]{Token.create(text2)}))) != null) {
                text2 = normalizedText;
            }
            if ("uima.cas.String".equals(this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setStringValue(this.mStructureFeature, text2);
                continue;
            }
            try {
                number2 = NumberUtil.parse(text2, language);
            }
            catch (ParseException e) {
                if (!this.mLogger.isLoggable(Level.INFO)) continue;
                this.mLogger.log(Level.INFO, "Invalid number format: " + text2);
                continue;
            }
            if ("uima.cas.Byte".equals(this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setByteValue(this.mStructureFeature, number2.byteValue());
                continue;
            }
            if ("uima.cas.Short".equals(this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setShortValue(this.mStructureFeature, number2.shortValue());
                continue;
            }
            if ("uima.cas.Integer".equals(this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setIntValue(this.mStructureFeature, number2.intValue());
                continue;
            }
            if ("uima.cas.Long".equals(this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setLongValue(this.mStructureFeature, number2.longValue());
                continue;
            }
            if ("uima.cas.Float".equals(this.mStructureFeature.getRange().getName())) {
                nameAnnotation.setFloatValue(this.mStructureFeature, number2.floatValue());
                continue;
            }
            if (!"uima.cas.Double".equals(this.mStructureFeature.getRange().getName())) continue;
            nameAnnotation.setDoubleValue(this.mStructureFeature, number2.doubleValue());
        }
    }

    static {
        HashSet<String> supportedTypes = new HashSet<String>();
        supportedTypes.add("uima.cas.String");
        supportedTypes.add("uima.cas.Byte");
        supportedTypes.add("uima.cas.Short");
        supportedTypes.add("uima.cas.Integer");
        supportedTypes.add("uima.cas.Long");
        supportedTypes.add("uima.cas.Float");
        supportedTypes.add("uima.cas.Double");
        SUPPORTED_TYPES = Collections.unmodifiableSet(supportedTypes);
    }
}

