/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.namefind.AdaptiveFeatureGenerator;
import opennlp.tools.namefind.CharacterNgramFeatureGenerator;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.DictionaryFeatureGenerator;
import opennlp.tools.namefind.DictionaryNameFinder;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleStream;
import opennlp.tools.namefind.TokenClassFeatureGenerator;
import opennlp.tools.namefind.TokenFeatureGenerator;
import opennlp.tools.namefind.TokenPatternFeatureGenerator;
import opennlp.tools.namefind.WindowFeatureGenerator;
import opennlp.tools.ngram.Token;
import opennlp.tools.util.DataStreamBuilder;
import opennlp.tools.util.Span;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public final class NameFinderTrainer
extends CasConsumer_ImplBase {
    private UimaContext mContext;
    private String mModelName;
    private Type mSentenceType;
    private Type mTokenType;
    private Type mNameType;
    private Type[] additonalContextTypes;
    private DataStreamBuilder mNameFinderEvents;
    private Logger mLogger;
    private NameContextGenerator mNameFinderContext;

    public void initialize() throws ResourceInitializationException {
        Boolean tokenPatternSupport;
        Dictionary nameDictionary;
        Boolean isTokenClassFeatureGenertorEnabled;
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Name Trainer.");
        }
        this.mNameFinderEvents = new DataStreamBuilder();
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        ArrayList<AdaptiveFeatureGenerator> generators = new ArrayList<AdaptiveFeatureGenerator>();
        generators.add(new CharacterNgramFeatureGenerator());
        Boolean isTokenFeatureGeneratorEnabled = CasConsumerUtil.getOptionalBooleanParameter(this.mContext, "opennlp.uima.namefinder.TokenFeature");
        if (isTokenFeatureGeneratorEnabled == null) {
            isTokenFeatureGeneratorEnabled = Boolean.TRUE;
        }
        if (isTokenFeatureGeneratorEnabled.booleanValue()) {
            Integer nextWindowSize;
            Integer prevWindowSize = CasConsumerUtil.getOptionalIntegerParameter(this.mContext, "opennlp.uima.namefinder.TokenFeature.previousWindowSize");
            if (prevWindowSize == null) {
                prevWindowSize = new Integer(5);
            }
            if ((nextWindowSize = CasConsumerUtil.getOptionalIntegerParameter(this.mContext, "opennlp.uima.namefinder.TokenFeature.nextWindowSize")) == null) {
                nextWindowSize = new Integer(5);
            }
            generators.add(new WindowFeatureGenerator(new TokenFeatureGenerator(), prevWindowSize, nextWindowSize));
        }
        if ((isTokenClassFeatureGenertorEnabled = CasConsumerUtil.getOptionalBooleanParameter(this.mContext, "opennlp.uima.namefinder.TokenClassFeature")) == null) {
            isTokenClassFeatureGenertorEnabled = Boolean.TRUE;
        }
        if (isTokenClassFeatureGenertorEnabled.booleanValue()) {
            Integer nextWindowSize;
            Integer prevWindowSize = CasConsumerUtil.getOptionalIntegerParameter(this.mContext, "opennlp.uima.namefinder.TokenClassFeature.previousWindowSize");
            if (prevWindowSize == null) {
                prevWindowSize = new Integer(3);
            }
            if ((nextWindowSize = CasConsumerUtil.getOptionalIntegerParameter(this.mContext, "opennlp.uima.namefinder.TokenClassFeature.nextWindowSize")) == null) {
                nextWindowSize = new Integer(3);
            }
            generators.add(new WindowFeatureGenerator(new TokenClassFeatureGenerator(), prevWindowSize, nextWindowSize));
        }
        if ((nameDictionary = CasConsumerUtil.createOptionalDictionary(this.mContext, "opennlp.uima.Dictionary")) != null) {
            generators.add(new DictionaryFeatureGenerator(new DictionaryNameFinder(nameDictionary)));
        }
        if ((tokenPatternSupport = CasConsumerUtil.getOptionalBooleanParameter(this.mContext, "opennlp.uima.TokenPatternOptimization")) == null) {
            tokenPatternSupport = Boolean.FALSE;
        }
        if (tokenPatternSupport.booleanValue()) {
            generators.add(new TokenPatternFeatureGenerator());
        }
        this.mNameFinderContext = new DefaultNameContextGenerator(generators.toArray(new AdaptiveFeatureGenerator[generators.size()]));
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String nameTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.NameType");
        this.mNameType = CasConsumerUtil.getType(typeSystem, nameTypeName);
        String[] additionaContextTypeStrings = CasConsumerUtil.getOptionalStringArrayParameter(this.mContext, "opennlp.uima.AdditionalContextType");
        this.additonalContextTypes = new Type[additionaContextTypeStrings.length];
        for (int i = 0; i < additionaContextTypeStrings.length; ++i) {
            this.additonalContextTypes[i] = typeSystem.getType(additionaContextTypeStrings[i]);
        }
    }

    public void processCas(CAS cas) {
        AnnotationIndex<AnnotationFS> sentenceIndex = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentenceAnnotation : sentenceIndex) {
            this.process(cas, sentenceAnnotation);
        }
    }

    static List iteratorToList(Iterator it) {
        LinkedList<AnnotationFS> list2 = new LinkedList<AnnotationFS>();
        while (it.hasNext()) {
            list2.add((AnnotationFS)it.next());
        }
        return list2;
    }

    public static String[][] createAdditioinalConextUima(CAS cas, AnnotationFS sentence, List tokens, Type[] types) {
        LinkedList names = new LinkedList();
        for (int i = 0; i < types.length; ++i) {
            ContainingConstraint sentenceContainingConstraint = new ContainingConstraint(sentence);
            AnnotationIndex<AnnotationFS> allNames = cas.getAnnotationIndex(types[i]);
            FSIterator containingNames = cas.createFilteredIterator(allNames.iterator(), sentenceContainingConstraint);
            while (containingNames.hasNext()) {
                names.add(containingNames.next());
            }
        }
        return NameFinderTrainer.createAdditionalContext(tokens.size(), NameFinderTrainer.createNames(tokens, names), names);
    }

    public static String[][] createAdditionalContext(int numberOfTokens, Span[] names, List annotations) {
        String[][] additionalContext = new String[numberOfTokens][];
        for (int tokenIndex = 0; tokenIndex < numberOfTokens; ++tokenIndex) {
            LinkedList<String> tokenContext = new LinkedList<String>();
            for (int nameIndex = 0; nameIndex < names.length; ++nameIndex) {
                if (names[nameIndex].getStart() == tokenIndex) {
                    tokenContext.add("start_" + ((AnnotationFS)annotations.get(nameIndex)).getType().getShortName());
                    continue;
                }
                if (names[nameIndex].getStart() >= tokenIndex || tokenIndex >= names[nameIndex].getEnd()) continue;
                tokenContext.add("cont_" + ((AnnotationFS)annotations.get(nameIndex)).getType().getShortName());
            }
            additionalContext[tokenIndex] = tokenContext.toArray(new String[tokenContext.size()]);
        }
        return additionalContext;
    }

    private void process(CAS cas, AnnotationFS sentence) {
        ContainingConstraint sentenceContainingConstraint = new ContainingConstraint(sentence);
        AnnotationIndex<AnnotationFS> tokenAnnotations = cas.getAnnotationIndex(this.mTokenType);
        FSIterator containingTokens = cas.createFilteredIterator(tokenAnnotations.iterator(), sentenceContainingConstraint);
        AnnotationIndex<AnnotationFS> allNames = cas.getAnnotationIndex(this.mNameType);
        FSIterator containingNames = cas.createFilteredIterator(allNames.iterator(), sentenceContainingConstraint);
        List tokenList = NameFinderTrainer.iteratorToList(containingTokens);
        Span[] names = NameFinderTrainer.createNames(tokenList, NameFinderTrainer.iteratorToList(containingNames));
        Token[] tokenArray = new Token[tokenList.size()];
        for (int i = 0; i < tokenArray.length; ++i) {
            tokenArray[i] = Token.create(((AnnotationFS)tokenList.get(i)).getCoveredText());
        }
        String[][] additionalContext = NameFinderTrainer.createAdditioinalConextUima(cas, sentence, tokenList, this.additonalContextTypes);
        NameSample traingSentence = new NameSample(tokenArray, names, null, additionalContext, false);
        if (traingSentence.getSentence().length != 0) {
            this.mNameFinderEvents.add(traingSentence);
        } else if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Sentence without tokens: " + sentence.getCoveredText());
        }
    }

    private static Span[] createNames(List tokenList, List entityAnnotations) {
        LinkedList<Span> nameList = new LinkedList<Span>();
        AnnotationFS currentEntity = null;
        int startIndex = -1;
        int index = 0;
        for (AnnotationFS token2 : tokenList) {
            for (AnnotationFS entity : entityAnnotations) {
                if (!NameFinderTrainer.isContaining(entity, token2)) {
                    if (currentEntity != entity) continue;
                    Span name = new Span(startIndex, index);
                    nameList.add(name);
                    startIndex = -1;
                    currentEntity = null;
                }
                if (currentEntity != null || !NameFinderTrainer.isContaining(entity, token2)) continue;
                startIndex = index;
                currentEntity = entity;
            }
            ++index;
        }
        if (currentEntity != null) {
            Span name = new Span(startIndex, index);
            nameList.add(name);
        }
        return nameList.toArray(new Span[nameList.size()]);
    }

    private static boolean isContaining(AnnotationFS annotation, AnnotationFS containtedAnnotation) {
        boolean isEndContaining;
        boolean isStartContaining;
        boolean bl = isStartContaining = annotation.getBegin() <= containtedAnnotation.getBegin();
        if (!isStartContaining) {
            return false;
        }
        boolean bl2 = isEndContaining = annotation.getEnd() >= containtedAnnotation.getEnd();
        return isEndContaining;
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GISModel nameModel;
        GIS.PRINT_MESSAGES = false;
        NameFinderEventStream nameFinderEventStream = new NameFinderEventStream(new NameSampleStream(){

            public boolean hasNext() {
                return NameFinderTrainer.this.mNameFinderEvents.hasNext();
            }

            public NameSample next() {
                return (NameSample)NameFinderTrainer.this.mNameFinderEvents.nextToken();
            }
        }, this.mNameFinderContext);
        try {
            nameModel = NameFinderME.train(nameFinderEventStream, 100, 3);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        this.mNameFinderEvents = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(nameModel, new FileOutputStream(modelFile));
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mNameFinderEvents = null;
    }
}

