/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.doccat;

import java.io.InputStream;
import opennlp.maxent.GISModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class DocumentCategorizer
extends CasAnnotator_ImplBase {
    private UimaContext context;
    private Logger mLogger;
    private opennlp.tools.doccat.DocumentCategorizer mCategorizer;
    private Type mTokenType;
    private Type mCategoryType;
    private Feature mCategoryFeature;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Categorizer.");
        }
        InputStream inModel = AnnotatorUtil.getResourceAsStream(context, UimaUtil.MODEL_PARAMETER);
        GISModel categorizerModel = OpennlpUtil.createModel(inModel);
        this.mCategorizer = new DocumentCategorizerME(categorizerModel);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mCategoryType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.doccat.CategoryType");
        this.mCategoryFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mCategoryType, "opennlp.uima.doccat.CategoryFeature", "uima.cas.String");
    }

    public void process(CAS tcas) {
        double[] result2 = this.mTokenType != null ? this.mCategorizer.categorize(tcas.getDocumentText()) : this.mCategorizer.categorize(tcas.getDocumentText());
        String bestCategroy = this.mCategorizer.getBestCategory(result2);
        AnnotationIndex<AnnotationFS> categoryIndex = tcas.getAnnotationIndex(this.mCategoryType);
        AnnotationFS categoryAnnotation = categoryIndex.size() > 0 ? categoryIndex.iterator().next() : null;
        if (categoryIndex.size() > 0) {
            categoryAnnotation = (AnnotationFS)categoryIndex.iterator().next();
        } else {
            categoryAnnotation = tcas.createAnnotation(this.mCategoryType, 0, tcas.getDocumentText().length());
            tcas.getIndexRepository().addFS(categoryAnnotation);
        }
        categoryAnnotation.setStringValue(this.mCategoryFeature, bestCategroy);
    }
}

