/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.chunker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.util.DataStreamBuilder;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class ChunkerTrainer
extends CasConsumer_ImplBase {
    private DataStreamBuilder mChunkEvents;
    private UimaContext mContext;
    private String mModelName;
    private Type mSentenceType;
    private Type mTokenType;
    private Feature mPOSFeature;
    private Type mChunkType;
    private Feature mChunkTagFeature;
    private Logger mLogger;

    public void initialize() throws ResourceInitializationException {
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Chunker Trainer.");
        }
        this.mChunkEvents = new DataStreamBuilder();
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
        String chunkTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.ChunkType");
        this.mChunkType = CasConsumerUtil.getType(typeSystem, chunkTypeName);
        String chunkTagFeature = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.ChunkTagFeature");
        this.mChunkTagFeature = this.mChunkType.getFeatureByBaseName(chunkTagFeature);
        CasConsumerUtil.checkFeatureType(this.mChunkTagFeature, "uima.cas.String");
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String posFeatureName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.POSFeature");
        this.mPOSFeature = this.mTokenType.getFeatureByBaseName(posFeatureName);
        CasConsumerUtil.checkFeatureType(this.mPOSFeature, "uima.cas.String");
    }

    public void processCas(CAS cas) {
        AnnotationIndex<AnnotationFS> sentenceIndex = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentenceAnnotation : sentenceIndex) {
            this.processSentence(cas, sentenceAnnotation);
        }
    }

    private void processSentence(CAS tcas, AnnotationFS sentence) {
        AnnotationIndex<AnnotationFS> chunkIndex = tcas.getAnnotationIndex(this.mChunkType);
        ContainingConstraint containingConstraint = new ContainingConstraint(sentence);
        FSIterator chunkIterator = tcas.createFilteredIterator(chunkIndex.iterator(), containingConstraint);
        while (chunkIterator.hasNext()) {
            AnnotationFS chunkAnnotation = (AnnotationFS)chunkIterator.next();
            this.processChunk(tcas, chunkAnnotation);
        }
    }

    private void processChunk(CAS tcas, AnnotationFS chunk) {
        String chunkTag = chunk.getFeatureValueAsString(this.mChunkTagFeature);
        AnnotationIndex<AnnotationFS> tokenIndex = tcas.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(chunk);
        FSIterator tokenIterator = tcas.createFilteredIterator(tokenIndex.iterator(), containingConstraint);
        while (tokenIterator.hasNext()) {
            AnnotationFS tokenAnnotation = (AnnotationFS)tokenIterator.next();
            String posTag = tokenAnnotation.getFeatureValueAsString(this.mPOSFeature);
            String chunkEvent = tokenAnnotation.getCoveredText() + ' ' + posTag + ' ' + chunkTag;
            this.mChunkEvents.add(chunkEvent);
        }
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        GISModel chunkerModel = ChunkerME.train(new ChunkerEventStream(this.mChunkEvents), 100, 5);
        this.mChunkEvents = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(chunkerModel, new FileOutputStream(modelFile));
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mChunkEvents = null;
    }
}

