/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

public class Span
implements Comparable {
    private int start;
    private int end;

    public Span(int s, int e) {
        this.start = s;
        this.end = e;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(Span s) {
        return this.start <= s.getStart() && s.getEnd() <= this.end;
    }

    public boolean contains(int index) {
        return this.start <= index && index <= this.end;
    }

    public boolean startsWith(Span s) {
        return this.getStart() == s.getStart() && this.contains(s);
    }

    public boolean intersects(Span s) {
        int sstart = s.getStart();
        return this.contains(s) || s.contains(this) || this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd();
    }

    public boolean crosses(Span s) {
        int sstart = s.getStart();
        return !this.contains(s) && !s.contains(this) && (this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd());
    }

    public String getCoveredText(String text2) {
        if (this.getEnd() > text2.length()) {
            throw new IllegalArgumentException("The span " + this.toString() + " is outside the given text!");
        }
        return text2.substring(this.getStart(), this.getEnd());
    }

    public int compareTo(Object o) {
        Span s = (Span)o;
        if (this.getStart() < s.getStart()) {
            return -1;
        }
        if (this.getStart() == s.getStart()) {
            if (this.getEnd() > s.getEnd()) {
                return -1;
            }
            if (this.getEnd() < s.getEnd()) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return this.start << 16 | 0xFFFF | this.end;
    }

    public boolean equals(Object o) {
        boolean result2;
        if (o == this) {
            result2 = true;
        } else if (o instanceof Span) {
            Span s = (Span)o;
            result2 = this.getStart() == s.getStart() && this.getEnd() == s.getEnd();
        } else {
            result2 = false;
        }
        return result2;
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer(15);
        toStringBuffer.append(this.getStart());
        toStringBuffer.append("..");
        toStringBuffer.append(this.getEnd());
        return toStringBuffer.toString();
    }

    public static String[] spansToStrings(Span[] spans, String s) {
        String[] tokens = new String[spans.length];
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            tokens[si] = spans[si].getCoveredText(s);
        }
        return tokens;
    }

    public static String[] spansToStrings(Span[] spans, String[] tokens) {
        String[] chunks = new String[spans.length];
        StringBuffer cb = new StringBuffer();
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            cb.setLength(0);
            for (int ti = spans[si].getStart(); ti < spans[si].getEnd(); ++ti) {
                cb.append(tokens[ti]).append(" ");
            }
            chunks[si] = cb.substring(0, cb.length() - 1);
        }
        return chunks;
    }
}

