/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.util.NumberedSet;

public class CountedNumberedSet
extends NumberedSet {
    private Map cset;
    private int max;

    public CountedNumberedSet() {
        this.cset = new HashMap();
        this.max = 1;
    }

    public CountedNumberedSet(int size2) {
        this.cset = new HashMap(size2);
        this.max = 1;
    }

    public boolean add(Object o) {
        int[] nums = (int[])this.cset.get(o);
        if (nums == null) {
            this.cset.put(o, new int[]{1, this.max++});
            return true;
        }
        nums[0] = nums[0] + 1;
        return false;
    }

    public void subtract(Object o) {
        int[] count2 = (int[])this.cset.get(o);
        if (count2 != null) {
            count2[0] = count2[0] - 1;
            if (count2[0] <= 0) {
                this.cset.remove(o);
            }
        }
    }

    public void setCount(Object o, int c) {
        int[] nums = (int[])this.cset.get(o);
        if (nums != null) {
            nums[0] = c;
        } else {
            this.cset.put(o, new int[]{c, 1});
        }
    }

    public int getCount(Object o) {
        int[] nums = (int[])this.cset.get(o);
        if (nums == null) {
            return 0;
        }
        return nums[0];
    }

    public int getIndex(Object key) {
        int[] nums = (int[])this.cset.get(key);
        if (nums == null) {
            return -1;
        }
        return nums[1];
    }

    public void write(String fileName, int countCutoff) {
        this.write(fileName, countCutoff, " ");
    }

    public void write(String fileName, int countCutoff, String delim) {
        this.write(fileName, countCutoff, delim, null);
    }

    public void write(String fileName, int countCutoff, String delim, String encoding) {
        PrintWriter out = null;
        try {
            out = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding)) : new PrintWriter(new FileWriter(fileName));
            Iterator e = this.cset.keySet().iterator();
            while (e.hasNext()) {
                Object key = e.next();
                int count2 = this.getCount(key);
                if (count2 < countCutoff) continue;
                out.println(count2 + delim + key);
            }
            out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator ci = c.iterator();
        while (ci.hasNext()) {
            changed = changed || this.add(ci.next());
        }
        return changed;
    }

    public void clear() {
        this.cset.clear();
    }

    public boolean contains(Object o) {
        return this.cset.keySet().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.cset.keySet().containsAll(c);
    }

    public boolean isEmpty() {
        return this.cset.isEmpty();
    }

    public Iterator iterator() {
        return this.cset.keySet().iterator();
    }

    public boolean remove(Object o) {
        return this.cset.remove(o) != null;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator ki = this.cset.keySet().iterator();
        while (ki.hasNext()) {
            changed = changed || this.cset.remove(ki.next()) != null;
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        Iterator ki = this.cset.keySet().iterator();
        while (ki.hasNext()) {
            Object key = ki.next();
            if (c.contains(key)) continue;
            this.cset.remove(key);
            changed = true;
        }
        return changed;
    }

    public int size() {
        return this.cset.size();
    }

    public Object[] toArray() {
        return this.cset.keySet().toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.cset.keySet().toArray(arg0);
    }
}

