/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollector;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.Pair;

public class POSEventCollector
implements EventCollector {
    private BufferedReader br;
    private POSContextGenerator cg;

    public POSEventCollector(Reader data2, POSContextGenerator gen) {
        this.br = new BufferedReader(data2);
        this.cg = gen;
    }

    private static Pair split(String s) {
        int split2 = s.lastIndexOf("_");
        if (split2 == -1) {
            System.out.println("There is a problem in your training data: " + s + " does not conform to the format WORD_TAG.");
            return new Pair(s, "UNKNOWN");
        }
        return new Pair(s.substring(0, split2), s.substring(split2 + 1));
    }

    public static Pair convertAnnotatedString(String s) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        ArrayList<Object> outcomes = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            Pair p = POSEventCollector.split(st.nextToken());
            tokens.add(p.a);
            outcomes.add(p.b);
        }
        return new Pair(tokens, outcomes);
    }

    public Event[] getEvents() {
        return this.getEvents(false);
    }

    public Event[] getEvents(boolean evalMode) {
        ArrayList<Event> elist = new ArrayList<Event>();
        try {
            String s = this.br.readLine();
            while (s != null) {
                Pair p = POSEventCollector.convertAnnotatedString(s);
                ArrayList tokens = (ArrayList)p.a;
                ArrayList outcomes = (ArrayList)p.b;
                ArrayList tags = new ArrayList();
                for (int i = 0; i < tokens.size(); ++i) {
                    String[] context = this.cg.getContext(i, tokens.toArray(), tags.toArray(new String[tags.size()]), null);
                    Event e = new Event((String)outcomes.get(i), context);
                    tags.add(outcomes.get(i));
                    elist.add(e);
                }
                s = this.br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Event[] events2 = new Event[elist.size()];
        for (int i = 0; i < events2.length; ++i) {
            events2[i] = (Event)elist.get(i);
        }
        return events2;
    }
}

