/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.util.Cache;

public class ChunkContextGenerator
implements ChunkerContextGenerator {
    private static final String EOS = "eos";
    private Cache contextsCache;
    private Object wordsKey;

    public ChunkContextGenerator() {
        this(0);
    }

    public ChunkContextGenerator(int cacheSize) {
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    public String[] getContext(Object o) {
        Object[] data2 = (Object[])o;
        return this.getContext((int)((Integer)data2[0]), (Object[])((String[])data2[1]), (String[])data2[2], (String[])data2[3]);
    }

    public String[] getContext(int i, Object[] words, String[] prevDecisions, Object[] ac) {
        return this.getContext(i, words, (String[])ac[0], prevDecisions);
    }

    public String[] getContext(int i, Object[] words, String[] tags, String[] preds) {
        String w2;
        String t2;
        String w1;
        String t1;
        String w_1;
        String p_1;
        String t_1;
        String w_2;
        String p_2;
        String t_2;
        ArrayList<String> features = new ArrayList<String>(19);
        int x0 = i;
        int x_2 = x0 - 2;
        int x_1 = x0 - 1;
        int x2 = x0 + 2;
        int x1 = x0 + 1;
        if (x_2 >= 0) {
            t_2 = tags[x_2];
            p_2 = preds[x_2];
            w_2 = words[x_2].toString();
        } else {
            t_2 = EOS;
            p_2 = EOS;
            w_2 = EOS;
        }
        if (x_1 >= 0) {
            t_1 = tags[x_1];
            p_1 = preds[x_1];
            w_1 = words[x_1].toString();
        } else {
            t_1 = EOS;
            p_1 = EOS;
            w_1 = EOS;
        }
        String t0 = tags[x0];
        String w0 = words[x0].toString();
        if (x1 < tags.length) {
            t1 = tags[x1];
            w1 = words[x1].toString();
        } else {
            t1 = EOS;
            w1 = EOS;
        }
        if (x2 < tags.length) {
            t2 = tags[x2];
            w2 = words[x2].toString();
        } else {
            t2 = EOS;
            w2 = EOS;
        }
        String cacheKey = x0 + t_2 + t1 + t0 + t1 + t2 + p_2 + p_1;
        if (this.contextsCache != null) {
            if (this.wordsKey == words) {
                String[] contexts = (String[])this.contextsCache.get(cacheKey);
                if (contexts != null) {
                    return contexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = words;
            }
        }
        String ct_2 = this.chunkandpostag(-2, w_2, t_2, p_2);
        String ctbo_2 = this.chunkandpostagbo(-2, t_2, p_2);
        String ct_1 = this.chunkandpostag(-1, w_1, t_1, p_1);
        String ctbo_1 = this.chunkandpostagbo(-1, t_1, p_1);
        String ct0 = this.chunkandpostag(0, w0, t0, null);
        String ctbo0 = this.chunkandpostagbo(0, t0, null);
        String ct1 = this.chunkandpostag(1, w1, t1, null);
        String ctbo1 = this.chunkandpostagbo(1, t1, null);
        String ct2 = this.chunkandpostag(2, w2, t2, null);
        String ctbo2 = this.chunkandpostagbo(2, t2, null);
        features.add("default");
        features.add(ct_2);
        features.add(ctbo_2);
        features.add(ct_1);
        features.add(ctbo_1);
        features.add(ct0);
        features.add(ctbo0);
        features.add(ct1);
        features.add(ctbo1);
        features.add(ct2);
        features.add(ctbo2);
        features.add(ct_1 + "," + ct0);
        features.add(ctbo_1 + "," + ct0);
        features.add(ct_1 + "," + ctbo0);
        features.add(ctbo_1 + "," + ctbo0);
        features.add(ct0 + "," + ct1);
        features.add(ctbo0 + "," + ct1);
        features.add(ct0 + "," + ctbo1);
        features.add(ctbo0 + "," + ctbo1);
        String[] contexts = features.toArray(new String[features.size()]);
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }

    private String chunkandpostag(int i, String tok, String tag, String chunk) {
        StringBuffer feat = new StringBuffer(20);
        feat.append(i).append("=").append(tok).append("|").append(tag);
        if (i < 0) {
            feat.append("|").append(chunk);
        }
        return feat.toString();
    }

    private String chunkandpostagbo(int i, String tag, String chunk) {
        StringBuffer feat = new StringBuffer(20);
        feat.append(i).append("*=").append(tag);
        if (i < 0) {
            feat.append("|").append(chunk);
        }
        return feat.toString();
    }
}

