/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import opennlp.tools.namefind.AdaptiveFeatureGenerator;
import opennlp.tools.namefind.CachingNameFeatures;
import opennlp.tools.namefind.FeatureGeneratorUtil;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.PreviousMapFeatureGenerator;
import opennlp.tools.namefind.StaticFeatureGenerator;

public class DefaultNameContextGenerator
implements NameContextGenerator {
    private AdaptiveFeatureGenerator[] featureGenerators;
    private int callNum = 0;
    private int pc = 0;

    public DefaultNameContextGenerator() {
        this(null);
    }

    public DefaultNameContextGenerator(AdaptiveFeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators != null ? featureGenerators : new AdaptiveFeatureGenerator[]{StaticFeatureGenerator.instance().staticFeatures, new PreviousMapFeatureGenerator()};
    }

    public void addFeatureGenerator(AdaptiveFeatureGenerator generator) {
        AdaptiveFeatureGenerator[] generators = this.featureGenerators;
        this.featureGenerators = new AdaptiveFeatureGenerator[this.featureGenerators.length + 1];
        System.arraycopy(generators, 0, this.featureGenerators, 0, generators.length);
        this.featureGenerators[this.featureGenerators.length - 1] = generator;
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        if (tokens != null && outcomes != null && tokens.length != outcomes.length) {
            throw new IllegalArgumentException("The tokens and outcome arrays MUST have the same size!");
        }
        for (int i = 0; i < this.featureGenerators.length; ++i) {
            this.featureGenerators[i].updateAdaptiveData(tokens, outcomes);
        }
    }

    public void clearAdaptiveData() {
        for (int i = 0; i < this.featureGenerators.length; ++i) {
            this.featureGenerators[i].clearAdaptiveData();
        }
    }

    public String[] getContext(int index, Object[] sequence2, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence2, priorDecisions, (String[][])additionalContext);
    }

    public String[] getContext(int index, Object[] toks, String[] preds, String[][] additionalContext) {
        String[] tokens;
        String po = "other";
        String ppo = "other";
        CachingNameFeatures cnf = StaticFeatureGenerator.instance();
        if (index > 1) {
            ppo = preds[index - 2];
        }
        if (index > 0) {
            po = preds[index - 1];
        }
        if (cnf.prevTokens == toks) {
            tokens = cnf.prevStrings;
            if (index == cnf.cpi && po.equals(cnf.cpo) && ppo.equals(cnf.cppo)) {
                return cnf.prevContext;
            }
        } else {
            tokens = new String[toks.length];
            for (int i = 0; i < toks.length; ++i) {
                tokens[i] = toks[i].toString();
            }
            cnf.prevTokens = toks;
            cnf.prevStrings = tokens;
        }
        ArrayList<String> features = new ArrayList<String>();
        features.add("def");
        if (index == 0) {
            features.add("fwis");
        }
        for (int i = 0; i < this.featureGenerators.length; ++i) {
            this.featureGenerators[i].createFeatures(features, tokens, index, preds);
        }
        if (additionalContext != null && additionalContext.length != 0) {
            for (int aci = 0; aci < additionalContext[index].length; ++aci) {
                features.add(additionalContext[index][aci]);
            }
        }
        String wc = FeatureGeneratorUtil.tokenFeature(tokens[index]);
        features.add("po=" + po);
        features.add("pow=" + po + "," + tokens[index]);
        features.add("powf=" + po + "," + wc);
        features.add("ppo=" + ppo);
        cnf.prevContext = features.toArray(new String[features.size()]);
        cnf.cpi = index;
        cnf.cpo = po;
        cnf.cppo = ppo;
        return cnf.prevContext;
    }

    private void cacheReport() {
        System.err.println(this.callNum + " " + StaticFeatureGenerator.instance().staticFeatures.toString() + " pc=" + this.pc + " " + (double)this.pc / (double)this.callNum);
    }
}

