/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.german;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.InvalidFormatException;

public class PosTagger
extends POSTaggerME {
    public PosTagger(String modelFile, Dictionary dict, TagDictionary tagdict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(dict), tagdict);
    }

    public PosTagger(String modelFile, TagDictionary tagdict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(null), tagdict);
    }

    public PosTagger(String modelFile, Dictionary dict) {
        super(PosTagger.getModel(modelFile), new DefaultPOSContextGenerator(dict));
    }

    private static MaxentModel getModel(String name) {
        try {
            return new SuffixSensitiveGISModelReader(new File(name)).getModel();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void usage() {
        System.err.println("Usage: PosTagger [-d tagdict] [-di case_insensiteve_tagdict] [-k 5] model < tokenized_sentences");
        System.err.println("-d tagdict Specifies that a tag dictionary file should be used.");
        System.err.println("-di tagdict Specifies that a case-insensitive tag dictionary should be used.");
        System.err.println("-k n tagdict Specifies that the top n tagging should be reported.");
        System.exit(1);
    }

    public static void main(String[] args) throws InvalidFormatException, IOException {
        if (args.length == 0) {
            PosTagger.usage();
        }
        int ai = 0;
        boolean test2 = false;
        String tagdict = null;
        boolean caseSensitive = true;
        int numTaggings = 1;
        while (ai < args.length && args[ai].startsWith("-")) {
            if (args[ai].equals("-d")) {
                tagdict = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].equals("-di")) {
                tagdict = args[ai + 1];
                ai += 2;
                caseSensitive = false;
                continue;
            }
            if (!args[ai].equals("-k")) continue;
            numTaggings = Integer.parseInt(args[ai + 1]);
            ai += 2;
        }
        String model = args[ai++];
        String dictFile = null;
        if (ai < args.length) {
            dictFile = args[ai++];
        }
        PosTagger tagger = tagdict != null ? (dictFile != null ? new PosTagger(model, new Dictionary(new FileInputStream(dictFile)), (TagDictionary)new POSDictionary(tagdict, caseSensitive)) : new PosTagger(model, (TagDictionary)new POSDictionary(tagdict, caseSensitive))) : (dictFile != null ? new PosTagger(model, new Dictionary(new FileInputStream(dictFile))) : new PosTagger(model, (Dictionary)null));
        if (test2) {
            System.out.println(tagger.tag(args[ai]));
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String line = in.readLine();
            while (line != null) {
                if (numTaggings == 1) {
                    System.out.println(tagger.tag(line));
                } else {
                    String[] tokens = line.split(" ");
                    String[][] taggings = tagger.tag(numTaggings, tokens);
                    for (int ti = 0; ti < taggings.length; ++ti) {
                        for (int wi = 0; wi < tokens.length; ++wi) {
                            if (wi != 0) {
                                System.out.print(" ");
                            }
                            System.out.print(tokens[wi] + "/" + taggings[ti][wi]);
                        }
                        System.out.println();
                    }
                }
                line = in.readLine();
            }
        }
    }
}

