/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.ngram.Token;
import opennlp.tools.ngram.TokenList;
import opennlp.tools.util.InvalidFormatException;

public class Dictionary {
    private Set mEntrySet = new HashSet();
    private boolean caseSensitive;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Dictionary(InputStream in) throws IOException, InvalidFormatException {
        this(in, false);
    }

    public Dictionary(InputStream in, boolean caseSensitive) throws IOException, InvalidFormatException {
        this.caseSensitive = caseSensitive;
        DictionarySerializer.create(in, new EntryInserter(){

            public void insert(Entry entry) {
                Dictionary.this.put(entry.getTokens());
            }
        });
    }

    public void put(TokenList tokens) {
        if (this.caseSensitive) {
            this.mEntrySet.add(tokens);
        } else {
            this.mEntrySet.add(new IgnoreCaseTokenList(tokens));
        }
    }

    public boolean contains(TokenList tokens) {
        if (this.caseSensitive) {
            return this.mEntrySet.contains(tokens);
        }
        return this.mEntrySet.contains(new IgnoreCaseTokenList(tokens));
    }

    public void remove(TokenList tokens) {
        if (this.caseSensitive) {
            this.mEntrySet.remove(tokens);
        } else {
            this.mEntrySet.remove(new IgnoreCaseTokenList(tokens));
        }
    }

    public Iterator iterator() {
        final Iterator entries = this.mEntrySet.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return entries.hasNext();
            }

            public Object next() {
                Object o = entries.next();
                if (o instanceof IgnoreCaseTokenList) {
                    return ((IgnoreCaseTokenList)o).getTokenList();
                }
                return o;
            }

            public void remove() {
                entries.remove();
            }
        };
    }

    public int size() {
        return this.mEntrySet.size();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator entryIterator = new Iterator(){
            private Iterator mDictionaryIterator;
            {
                this.mDictionaryIterator = Dictionary.this.iterator();
            }

            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            public Object next() {
                TokenList tokens = (TokenList)this.mDictionaryIterator.next();
                return new Entry(tokens, new Attributes());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entryIterator);
    }

    public boolean equals(Object obj) {
        boolean result2;
        if (obj == this) {
            result2 = true;
        } else if (obj != null && obj instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)obj;
            result2 = ((Object)this.mEntrySet).equals(dictionary.mEntrySet);
        } else {
            result2 = false;
        }
        return result2;
    }

    public int hashCode() {
        return ((Object)this.mEntrySet).hashCode();
    }

    public String toString() {
        return this.mEntrySet.toString();
    }

    public static Dictionary parseOneEntryPerLine(Reader in) throws IOException {
        String line;
        BufferedReader lineReader = new BufferedReader(in);
        Dictionary dictionary = new Dictionary();
        while ((line = lineReader.readLine()) != null) {
            StringTokenizer whiteSpaceTokenizer = new StringTokenizer(line, " ");
            Token[] tokens = new Token[whiteSpaceTokenizer.countTokens()];
            if (tokens.length <= 0) continue;
            int tokenIndex = 0;
            while (whiteSpaceTokenizer.hasMoreTokens()) {
                tokens[tokenIndex++] = Token.create(whiteSpaceTokenizer.nextToken());
            }
            dictionary.put(new TokenList(tokens));
        }
        return dictionary;
    }

    private static class IgnoreCaseTokenList {
        private TokenList mTokenList;

        private IgnoreCaseTokenList(TokenList tokenList) {
            this.mTokenList = tokenList;
        }

        private TokenList getTokenList() {
            return this.mTokenList;
        }

        public boolean equals(Object obj) {
            boolean result2;
            if (obj == this) {
                result2 = true;
            } else if (obj instanceof IgnoreCaseTokenList) {
                IgnoreCaseTokenList other = (IgnoreCaseTokenList)obj;
                result2 = this.mTokenList.compareToIgnoreCase(other.getTokenList());
            } else {
                result2 = false;
            }
            return result2;
        }

        public int hashCode() {
            return this.mTokenList.toString().toLowerCase().hashCode();
        }

        public String toString() {
            return this.mTokenList.toString();
        }
    }
}

