/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import opennlp.maxent.AbstractDataIndexer;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;

public class OnePassDataIndexer
extends AbstractDataIndexer {
    public OnePassDataIndexer(EventStream eventStream) {
        this(eventStream, 0);
    }

    public OnePassDataIndexer(EventStream eventStream, int cutoff) {
        TObjectIntHashMap predicateIndex = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + cutoff + "\n");
        System.out.print("\tComputing event counts...  ");
        TLinkedList events2 = this.computeEventCounts(eventStream, predicateIndex, cutoff);
        System.out.println("done. " + events2.size() + " events");
        System.out.print("\tIndexing...  ");
        List eventsToCompare = this.index(events2, predicateIndex);
        events2 = null;
        predicateIndex = null;
        System.out.println("done.");
        System.out.print("Sorting and merging events... ");
        this.sortAndMerge(eventsToCompare);
        System.out.println("Done indexing.");
    }

    private TLinkedList computeEventCounts(EventStream eventStream, TObjectIntHashMap predicatesInOut, int cutoff) {
        HashSet predicateSet = new HashSet();
        TObjectIntHashMap<String> counter = new TObjectIntHashMap<String>();
        TLinkedList<Event> events2 = new TLinkedList<Event>();
        while (eventStream.hasNext()) {
            Event ev = eventStream.nextEvent();
            events2.addLast(ev);
            OnePassDataIndexer.update(ev.getContext(), predicateSet, counter, cutoff);
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            this.predCounts[index] = counter.get(predicate);
            predicatesInOut.put(predicate, index);
            ++index;
        }
        return events2;
    }

    protected List index(TLinkedList events2, TObjectIntHashMap predicateIndex) {
        TObjectIntHashMap<String> omap = new TObjectIntHashMap<String>();
        int numEvents = events2.size();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        TIntArrayList indexedContext = new TIntArrayList();
        int eventIndex = 0;
        while (eventIndex < numEvents) {
            int ocID;
            Event ev = (Event)events2.removeFirst();
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            int i = 0;
            while (i < econtext.length) {
                String pred = econtext[i];
                if (predicateIndex.containsKey(pred)) {
                    indexedContext.add(predicateIndex.get(pred));
                }
                ++i;
            }
            if (indexedContext.size() > 0) {
                ComparableEvent ce = new ComparableEvent(ocID, indexedContext.toNativeArray());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.resetQuick();
            ++eventIndex;
        }
        this.outcomeLabels = OnePassDataIndexer.toIndexedStringArray(omap);
        this.predLabels = OnePassDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

